function [a]=FEBase(y, x, dout, bn, P)
%Feature Extractor for Baseline
% y, x (noisy and clean signals)
% dout (utput dir)
% P   (Parameters structure)

%Parameters
P.FL=P.FSamp*P.FLSec; 
P.FS=P.FSamp*P.FSSec; 
P.N2pi=2^ceil(log2(P.FL*2));
P.win=hamming(P.FL); 


%FE
S=SegPrepr(P,y,x);
S=YXN(S,P);
WriteOutFiles(S,P,dout,bn);
a=min(S.Fby(:));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=SegPrepr(P,ys,xs)
%Segmentations
S.y=ys(:,end);  % S.y=OffPreEmph(S.y);
[S.My nf]=Segmx(S.y,P.FL,P.FS);
S.nf=nf;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=YXN(S,P)
%Spectrum 
S.Y=Msd(S.My,'x',P.N2pi,P);
S.Fby=SmoothFreqCompr(S.Y,P.NCH,P.FSamp,P.N2pi,P.MF);
S.Cy=Fbank2Cepst(S.Fby,-1,P.CepL,0,1,0);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function WriteOutFiles(S,P,do,bn)
%Write Output

PS.y=S.y; PS.Cxest=S.Cy; DemoPlotRes(PS,P)


S.Cy=AppDeltas(S.Cy,2,2,'feat');
WriteHTKF([do '/' bn '.Cxest'], S.Cy, 1);







   
		






    
    
    
    
