function WaterSegment(Fyo,WL)
%

Fy=GrayNorm(Fyo);
Fy=histeq(Fy,32);
Fnf=NoiseFloor(Fy,WL);
m=Fy>Fnf; Fy2=Fy; Fy2(not(m))=0;
subplot(411), imagesc(Fyo), axis xy
subplot(412), imagesc(Fy), axis xy
subplot(413), imagesc(Fnf), axis xy
subplot(414), imagesc(Fy2), axis xy
pause




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function B=GrayNorm(A)
%Gray(0-255)
ma=max(A(:)); mi=min(A(:));
B=(A-mi)/(ma-mi);

function B=NoiseFloor(A,WL)
%
[nch nf]=size(A);
B=zeros(nch,nf);
for i=1:nch
    x=A(i,:);
    [x,v]=MeanF(x,WL);
    x=MinF(x+sqrt(v),2*WL);
    B(i,:)=x;
end


function [m,v]=MeanF(x,hw)
%Mean Filter
ns=length(x);
m=x; v=x;
for i=1+hw:ns-hw; a=x(i-hw:i+hw); m(i)=mean(a); v(i)=var(a); end
a=x(1:hw); m(1:hw)=mean(a); v(1:hw)=var(a); 
a=x(ns-hw:ns); m(ns-hw:ns)=mean(a); v(ns-hw:ns)=var(a);



function xf=MinF(x,hw)
%Minimum Filter
nf=length(x); xf=x;
for i=1+hw:nf-hw; 
    xf(i)=min(x(i-hw:i+hw));
end
xf(1:hw)=min(x(1:hw)); xf(nf-hw:nf)=min(x(nf-hw:nf));
