function S=TakeExtFeat(ys, xs, do, bn, P, opt, S)
% Take the desired External Features
%Outputs: S.Epy,  S.Exest, S.Enest

SE=ExtFeat(ys, xs, do, bn, P, opt, S);

S.ext=false(1,3);
if(isfield(SE, 'py'));  
    pye=SE.py; [npit nfe]=size(pye);    
    S.Epy=zeros(npit,S.nf); lp=min(S.nf,nfe); S.Epy(:,1:lp)=pye(:,1:lp);    
    S.ext(1)=1;
else
    S.Epy=ones(1,S.nf);
end
if(isfield(SE, 'xest'));
    S.Exest=SE.xest;
    S.ext(2)=1;
else
    S.Exest=ones(1,length(S.y)); 
end
if(isfield(SE, 'nest'));
    S.Enest=SE.nest;
    S.ext(3)=1;
else
    S.Enest=ones(1,length(S.y)); 
end

