function [fragm, fmask]=OMaskFragm(omask)
%Oracle Mask Fragments

[nch nf]=size(omask);

n=zeros(nch,nf);
for i=1:nf
    n(:,i)=round(i/20)*ones(nch,1);
end
fragm=10*n+omask;
fragm = change_labels_for_plotting(fragm);

fmask=omask;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function frag2 = change_labels_for_plotting(frag)

labs = unique(frag);
frag2 = zeros(size(frag));

for i = 2:length(labs)
    frag2(frag==labs(i)) = i-1;
end