function a=FEChime(ys, xs, do, bn, P, opt)
%Feature Extractor based on Cochleagram (Gammatone)

%Parameters
P.LCFHz=50; % Low Center Freq (50 Hz)
P.HCFHz=round(P.FSamp/2-(P.FSamp/(P.NCH))); %High Center Freq  (3750 or 7500  Hz)
%(3875 or 7750  Hz if *2) (4000 or 8000 Hz if nothing)
P.FLms=P.FLSec*1000; %Frame Length (30 msec)
P.FSms=P.FSSec*1000; %Frame Shift (10 msec)
P.TIms=8; %Temporal integration (8 msec)
P.COMPR='log'; %Type of compression (default 'cuberoot')
P.HPitHz=[80 270]; %Expeted Humman pitch in Hz ([80 270] for A2. [x 400] for Chime, see NingMa)
P.WordLSec=(1/4); % Word Length in seconds (0.24 sec or 4 Hz)

%Derived parameters 
P.FL=P.FSamp*P.FLSec; %
P.FS=P.FSamp*P.FSSec; %
P.WordL=P.WordLSec*P.FSamp/P.FS; %
P.win=hamming(P.FL); %For Mel
P.HPit=[round(P.FSamp/P.HPitHz(2)) round(P.FSamp/P.HPitHz(1))]; %Human pitch in sample
P.FricF=round(2*P.NCH/3):P.NCH; %Fricative Frecuencies  (1800-4000 Hz)

%Options parameters
P.Thr=opt(1); %-9, Mask Threshold
P.HTh=opt(2); %0.75, HTh
P.EL=6; %6 Extrap Length

%Main functions of FE
S=NoisyFBank(ys,xs,P);
S=TakeExtFeat(ys, xs, do, bn, P, opt, S);
S=EnhCep(S,P);
S=PitEst(S,P);
S=MDMask(ys, xs, do, bn, P, opt, S);
%S=HarmF(ys, xs, do, bn, P, opt, S);
WriteOutFiles(S,do,bn,P);
a=min(S.Fby(:));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=NoisyFBank(ys,xs,P)
%Noisy FilterBank and Cepstrogram
S.y=ys(:,end); S.x=xs(:,end); S.n=S.y-S.x; %S.y=SubtSign(S.y,P);


%S.Fby = RateMap(S.y, P.FSamp, P.LCFHz, P.HCFHz, P.NCH, P.FSms, P.TIms, P.COMPR, P.MF, P.FL, P.FS);
%S.Fbn = RateMap(S.n, P.FSamp, P.LCFHz, P.HCFHz, P.NCH, P.FSms, P.TIms, P.COMPR, P.MF, P.FL, P.FS);
[CG,CGe,S.Fby,S.Ay,S.Aye,S.Hy]=CochlRateACGram(S.y,P.FSamp,P.LCFHz,P.HCFHz,P.NCH,P.FL,P.FS,P.HPit,P.MF);
[CG,CGe,S.Fbn,An,Ane,Hn]=CochlRateACGram(S.n,P.FSamp,P.LCFHz,P.HCFHz,P.NCH,P.FL,P.FS,P.HPit,P.MF);
[CG,CGe,S.Fbx,S.Ax,S.Axe,S.Hx]=CochlRateACGram(S.x,P.FSamp,P.LCFHz,P.HCFHz,P.NCH,P.FL,P.FS,P.HPit,P.MF);
S.nf=size(S.Fby,2);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=EnhCep(S,P)
%Cepstrum of enhaced signal
Fbxest = S.Fby;
S.Cxest=Fbank2Cepst(Fbxest,-1,P.CepL,0,1,0);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=PitEst(S,P)
%Pitch Estimation
%S.py=HPitch(S.Ax,S.Axe,S.Hx,P.HPit,P.WordL,P.HTh);
S.py=S.Epy(3,:);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=MDMask(ys, xs, do, bn, P, opt, S)
%Enhanced Cepstrogram
[S.vy, S.GSNResty]=VAD(S.Fby,S.py,P); 
S.omask=SNRMaskYN(exp(S.Fby),exp(S.Fbn),P.Thr,exp(P.MF));
[S.mask]=VADHarmN(S.Fby,S.Ay,S.Hy,S.py,S.vy,P.MF,P.EL,P.Thr,P.HTh,P.FricF,S.omask);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=HarmF(ys, xs, do, bn, P, opt, S)
%Harmonicity Fragments
%[S.Fragm, S.fmask]=NingFG(do, bn, P, S.y);
WaterSegment(S.Fby,P.WordL);
[S.Fragm, S.fmask]=OMaskFragm(S.omask);
%[S.CG1,S.CG2]=CochlGram(S.y1,S.y2,P.FSamp,P.LCFHz, P.HCFHz,P.NCH);
%S.CC=CCGram(S.CG1,S.CG2,P.FSamp,P.FLms,P.FSms);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function WriteOutFiles(S,do,bn,P)
%Write Output

%  subplot(511), imagesc(S.Cxest), axis xy,  title('Noisy Cepstrogram')
%  subplot(512), imagesc(S.Fby), axis xy,  title('Noisy Filterbankgram')
%  subplot(513), plot(S.py), hold on, plot(mean(S.py)*S.vy/3,'r'), hold off, xlim([1 S.nf]),axis xy, title('Noisy pitch')
%  subplot(514), imagesc(S.mask), axis xy,  title('Mask estimation')
%  %subplot(513), imagesc(S.Fragm), axis xy,  title('Fragm estimation')
%  %subplot(514), imagesc(S.fmask), axis xy,  title('Fragm mask estimation')
%  subplot(515), imagesc(S.omask), axis xy,  title('Oracle mask')
%  pause


 

S.Cxest=AppDeltas(S.Cxest,2,2,'feat');
S.Fby=AppDeltas(S.Fby,2,-1,'feat');
WriteHTKF([do '/' bn '.Cxest'], S.Cxest,0);
WriteHTKF([do '/' bn '.Fby'], S.Fby,0);
S.mask=AppDeltas(S.mask,2,-1,'mask');
S.omask=AppDeltas(S.omask,2,-1,'mask');
WriteHTKF([do '/' bn '.mask'], S.mask,0);
WriteHTKF([do '/' bn '.omask'], S.omask,0);


% S.Fragm=AppDeltas(S.Fragm,2,-1,'fragm');
% S.fmask=AppDeltas(S.fmask,2,-1,'mask');
% WriteHTKF([do '/' bn '.fmask'], S.fmask,0);
% WriteHTKF([do '/' bn '.fragm'], S.Fragm,0);





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function y=SubtSign(yo,P)
%Subtitute Signal
l=length(yo);
y=randn(1,l);
%P.f0=150; P.NSamp=l; [y,P]=Signals('PhonRuleSynth','i',P);
%y=yo;











