function [TG,HM2d]=HTGram(A,Ho,HTh,PitMi,PitMa)
%Harmonicity Tonegram
%Harmonicity AC
H=Ho;
F = fspecial('disk',1); H = imfilter(Ho,F,'replicate'); H=NormM(H); 
% subplot(211), imagesc(Ho), axis xy
% subplot(212), imagesc(H), axis xy
% pause

[nch,nk,nf]=size(A); %A0=repmat(A(:,1,:),[1 nk]); An=A./A0; 
HM2d=H>HTh; HM3d=true(nch,nk,nf); for i=1:nk; HM3d(:,i,:)=HM2d; end


HM=(HM3d);%&(A>0)&(An>HTh); 
Ah=zeros(nch,nk,nf); Ah(HM)=A(HM); 

% f=nf;
% for ch=1:nch
%     plot(A(ch,:,f))
%     ch, pause
% end

%Harm Summary AC
SA=squeeze(sum(Ah)); 
%NonIntensity Sum Harm AC
%SA=squeeze(sum(HM)); 
%Summary AC
%SA=squeeze(sum(A)); 

%Tonegram normalization
TG=SA(1:PitMa+1,:); TG(1:PitMi+1,:)=0; TG(TG<0)=0;
TG=sign(TG).*sqrt(abs(TG));
TG=nthroot(TG,3); 
TG=NormM(TG);

%TG=histeq(TG,64);
%TG=PSamp2AFreq(TG,PitMi,PitMa,55,30);
%Plot
% f=109;
% for c=1:nch
%   subplot(211), plot(Ah(c,:,f))
%   subplot(212), plot(A(c,:,f))
%   c, pause
% end



function HMask=HarmMask(HM,HTh)
%Harmonicity Mask
mhr=HM>HTh; HMask=mhr;
mhm=medfilt2(mhr,[2 5]); mh=mhm|mhr; HMask=bwareaopen(mh,4);


function Ah=HCGram(A,HMask)
%Harmonicity Correlogram
[nch,mk,nf]=size(A); HMM=false(nch,mk,nf); HMM(:,1,:)=HMask; HMM=repmat(HMM(:,1,:),[1 mk 1]); Ah=A; Ah(not(HMM))=0;

function CG=AcTGram(y,FL,FS,pl,ph)
%AutoCorr ChromaGram
[My, nf]=Segmx(y,FL,FS);
[Rb, Rosab,Rosau]=Mx2Rx(My); 
CG=Rosau(1:ph+1,:); 
s=sign(CG); CG=s.*sqrt(abs(CG));
CG=TGTransf(CG,'norm',-1);
%CG=medfilt2(CG,[11 3]);
CG(1:pl,:)=0;

