function py=HPitch(Ay,Ae,H,HPit,WordL,HTh,Epy)
%Harmonicity-based Pitch

%Parameters
f=0.75; %Energy floor factor
hf=1; %Half voiced filter


%Harmonicity Tonegram
PitMi=HPit(1); PitMa=HPit(2); 
[TG,HM]=HTGram(Ay,H,HTh,PitMi,PitMa);

%Dtw Pitch
[nch, nf]=size(TG);
[DtwP]=DTWPit(TG);

%Fine Pit, Fine Energy and Mean Energy
[FineP,FineE]=FinePit(DtwP,TG,2);
%MeanE=mean(TG);
SA=squeeze(sum(Ay)); MeanE=sqrt(SA(1,:));


%Voice detection and final pitch
[v,MeanEF,FineEF]=VDetect(MeanE,FineE,f,hf,WordL);
py=FineP; py(not(v))=0;


% subplot(511), imagesc(TG), axis xy
% subplot(512), imagesc(HM), axis xy
% subplot(513), plot(MeanE), hold on, plot(MeanEF,'r'), hold off, xlim([1 nf])
% subplot(514), plot(FineE), hold on, plot(FineEF,'r'), hold off, xlim([1 nf])
% subplot(515), plot(py), hold on, plot(FineP), hold off, xlim([1 nf])
% pause



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [v,MeanEF,FineEF]=VDetect(MeanE,FineE,f,hf,WordL)
%Voice Detection
MeanEF=NoiseFloor(MeanE,f,round(WordL/2));
FineEF=NoiseFloor(FineE,f,round(WordL/2));
v=MeanE>MeanEF & FineE>FineEF; 
%v=FineE>FineEF; 
v=ModeF(1*v,hf);


function [fp,E]=FinePit(p,TG,hl)
%Fine Pitch revision
%p is position not pitch
[nch, nf]=size(TG);
TGs=-1*ones(nch,nf);
for i=-hl:hl
    p2=min(p+i,nch); p2=max(p2,1);
    ind=sub2ind([nch nf],p2,1:nf); TGs(ind)=TG(ind);
end
[E fp]=max(TGs); 

function [pos]=DTWPit(TGo)
%Region Line. Return q in its correct position (to xmi)
%Find maximun energy trajectory
%TG must be normalized [0 1]
TG=-1*TGo+1; 
C = [1 1 1.0; -1 1 1.0; 0 1 1.0; -2 1 1.0; 2 1 1.0; -3 1 1.0; 3 1 1.0]; 
[pos,q]=dpfast_cons(TG,C); 



function B=NoiseFloor(A,f,hw)
%
B=A*f; B(B==0)=mean(B(B~=0));
B=MeanF(B,hw);




