function [CG,CGe,Fb,Ay,Ae,H]=CochlRateACGram(y,FSampHz,LCFHz,HCFHz,NCH,FL,FS,HPit,MF)
% Cochlea, Rate and AutoCorreloGram


%CG
[CG,CGe,cp]=CochlGram(y,FSampHz,LCFHz, HCFHz,NCH);


%H
[Ay,Ae,H]=ACHarmonicity(CG,CGe,cp,FL,FS,HPit);


%RateMap (Look out (cuidado) with low-freq last-frames)



Fb=log(sqrt(squeeze(Ay(:,1,:)))); Fb(Fb<MF)=MF;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [CG1,CG1e,cp]=CochlGram(y1,FSampHz,LCFHz, HCFHz,NCH)
%Cochleagram and corresponding Hilbert Envelope
%FSampHz    Sample Freq (16000 Hz)
%LCFHz      Low Center Freq (50 Hz)
%HCFHz      High Center Freq (7500 Hz)
%FLms       Frame Length (30 msec)
%FSms       Frame Shift (10 msec)
%TIms       Temporal integration (8 msec)
%COMPR      Type of compression ('log' or 'cuberoot')
ns=length(y1); 
CG1=zeros(NCH,ns); CG1e=zeros(NCH,ns); 
%Center Frequencies,
cf=MakeErbCFs(LCFHz,HCFHz,NCH); cp=round(FSampHz./cf);
for c=1:NCH
    %[CG1(c,:), env1]=gammatone_c(y1,FSampHz,cf(c),1);
    %CG1e(c,:)=env1;          
    CG1(c,:)=gammatone(y1,FSampHz,cf(c),true);
    CG1e(c,:)=abs(hilbert(CG1(c,:)));  
end





