function [Ay,Ae,H]=ACHarmonicity(CG,CGe,cp,FLo,FS,HPit)
%ACGram and corresponding Harmonicity


%Parameters
MinPerN=4; %Min Period Number
MuTh=0.3; % I take Mu(c,1:nf)=se/meo intuitively because the prob distribution of
% the evelope of a white noise is something like x*exp(x-u) but I am not sure.
%The Harmonicity (H) of a white noise is (MuTh,H): (0.0, 0.23) (0.3, 0.23) (0.5, 0.5)
%(1.0, 0.5); So I take MuTh=0.3 because is the inflexion point.  

%FL vector which depend on center gamm frequencies
FL=max(cp*MinPerN,FLo); FLma=max(FL); FLmi=min(FL); %FL vector (1280 716 ... 512)  
PitMi=HPit(1); PitMa=HPit(2); 

%
[NCH N]=size(CG);
nfo=ceil((N-FLmi)/FS);
R=zeros(FLma,nfo);
Ae=zeros(NCH,FLo,nfo);
Ay=zeros(NCH,FLo,nfo);
Mu=zeros(NCH,nfo);
H=zeros(NCH,nfo);

for c=1:NCH 
    %Segmentation depend on the channel FL and mean subtraction for
    %envelope and signal
    [Meo, nf]=Segmx(CGe(c,:),FL(c),FS); meo=mean(Meo); Me=Meo-repmat(meo,[FL(c) 1]); %Me=bsxfun(@minus, Me, me);
    [Myo, nf]=Segmx(CG(c,:),FL(c),FS); myo=mean(Myo); My=Myo-repmat(myo,[FL(c) 1]); %My=bsxfun(@minus, My, my);
    %Me=nthroot(Me,3); My=nthroot(My,3);
       

    %Unbiased osa correlation of the envelope (Re) and the signal (Ry)
    %[Rb, Ru, Rbosa, Re]=M2CC(Me,Me);   [Rb, Ru, Rbosa, Ry]=M2CC(My,My); 
    [Rba, Rua, Rb, Re]=M2AC(Me);  [Rba, Rua, Rb, Ry]=M2AC(My);   
    [Rba, Ryoa, Rb, Ryo]=M2AC(Myo);     Ryoe=abs(hilbert(Ryoa));     Ryoe=Ryoe(FL(c):end,:);
	 
    %Mu (modulation factor) is obtained by the original mean of the envelope (meo)
    %and the envelope standard deviation (se)
    ve=Re(1,:); se=sqrt(ve); Mu(c,1:nf)=se./meo; %1: high modulation, se./meo 

    
    %The A (autocorrelogram) should be Reyoe but if the Mu is small
    %(<0.3) this should be Ryo. This means that A is often pure positive (Ryoe) 
    %but sometimes pos and neg (Ryo);
    R(1:FL(c),1:nf)=Re;     i=Mu(c,1:nf)<MuTh;  R(1:FL(c),i)=Ry(:,i);
    Ae(c,:,1:nf)=Ryoe(1:FLo,1:nf); Ae(c,:,i)=Ryo(1:FLo,i);
    Ay(c,:,1:nf)=Ryo(1:FLo,1:nf);


    % Rn (normalized correlogram) 
    r0=R(1,:); Rn=R.*repmat(1./r0,[FLma 1]); %Rn=bsxfun(@times, R, 1./r0);
    
    % Harmonicity Mask is restricted to pitch lags except for low freq which is bigger    
    kmi=max(cp(c),PitMi); kma=max(2*kmi,PitMa);    k=kmi:kma;    H(c,:)=max(Rn(k,:)); 

%     f=109;
%     subplot(211), plot(Myo(:,f)), hold on, plot(Meo(:,f),'r'); hold off
%     subplot(212), plot(Rn(1:FLo,f)), hold on, plot(Rn(1:FLo,f),'r'); hold off
%     c, H(c,f), Mu(c,f), pause


end
%Correct NaN of low-freq last-frames
H(isnan(H))=0.5;

%  %Plot
%  [MuTh mean(H(:))]
%  subplot(211), plot(mean(Mu,2)),
%  subplot(212), imagesc(H), axis xy
%  pause

