function [a]=FEBFComp(y, x, do, bn, P)
%Feature Extractor (BeamForming+Compensation (Imput or VTS))
P.FL=P.FSamp*P.FLSec; 
P.FS=P.FSamp*P.FSSec; 
P.N2pi=2^ceil(log2(P.FL*2));
P.win=hamming(P.FL); 

%
P.MaPitHz   = 270; %Max Pitch (Hz) (270 Hz)
P.MiPitHz   = 80; %Min Pitch (Hz) (80 Hz)

%

P.Imput=P.FEOpt1; %Imputation
P.NoiseK=P.FEOpt2; %Noise Kind

P.PitK=0; %Pit Kind
P.Thr=-3; %mask Threshold
P.GSNRTh=5; % Global SNR Threshold
P.HFSNRTh=3; % High Freq Thr
P.FLFr=20; %First Last Frames
P.SmL=2; %Smooth time Length
P.ui=20; %Unvoiced Interval
P.FricFact=2/3; %Fricative Factor [0 1]
P.MiPitL  = round(P.FSamp/P.MaPitHz); %Min Pit Lag
P.MaPitL  = round(P.FSamp/P.MiPitHz);


S=SegmRepr(P,y,x);
S=PitVad(S,P);
S=Compensat(S,P,do);
WriteOutFiles(S,P,do,bn);
a=-1;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=SegmRepr(P,ys,xs)
%Segmentations and Representations
S.y=ys(:,end);  % S.y=OffPreEmph(S.y);
S.x=xs(:,end); S.n=S.y-S.x;
[S.My nf]=Segmx(S.y,P.FL,P.FS);
[S.Mx nf]=Segmx(S.x,P.FL,P.FS);
[S.Mn nf]=Segmx(S.n,P.FL,P.FS);
S.nf=nf;

S.Y=Msd(S.My,'x',P.N2pi,P);
S.X=Msd(S.Mx,'x',P.N2pi,P);
S.N=Msd(S.Mn,'x',P.N2pi,P);
S.Fby=SmoothFreqCompr(S.Y,P.NCH,P.FSamp,P.N2pi,P.MF);
S.Fbx=SmoothFreqCompr(S.X,P.NCH,P.FSamp,P.N2pi,P.MF);
S.Fbn=SmoothFreqCompr(S.N,P.NCH,P.FSamp,P.N2pi,P.MF);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=PitVad(S,P)
%
%Pitch and vad
px=DTWPitch(S.x,P); pxm=mean(px(px~=0));
py=DTWPitch(S.y,P,pxm); 
if (P.PitK==0);  S.pit=py;    
else  S.pit=px; end
[S.vad,S.GSNR]=VADPitHF(S.Fby,S.pit,P.FricFact,P.HFSNRTh,P.ui,P.FLFr,P.MinMS); S.GSNR


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=Compensat(S,P,do)
%Compensations

S.Fbnest=VadPitN(S.My,S.Y,S.Fby,S.pit,S.vad,S.GSNR,P,S.N,S.Fbn);

if ((~isempty(strfind(do,'Train')))||(P.Imput==0))
    S.Fbxest=S.Fby;
    
elseif (P.Imput==1)    
    S.Fbxest=Impute(P.mix,S.Fby,S.Fbnest,S.mask,P.MF,'Vts');
    
elseif (P.Imput==2)    
    M=[S.Fby(:,1:P.FLFr) S.Fby(:,end-P.FLFr:end)]; v=var(M,0,2); CovFbnest=repmat(v,[1, S.nf]);	
    S.Fbxest=Impute(P.mix,S.Fby,S.Fbnest,CovFbnest,P.MF,'VtsCov');	
	
elseif (P.Imput==3)
    S.mask=YNHardMask(exp(S.Fby),exp(S.Fbnest),P.Thr,exp(P.MF));    
    S.Fbxest=Impute(P.mix,S.Fby,S.Fbnest,S.mask,P.MF,'BinI');
    
else
    fprintf('ERROR: Unknown Imput\n');
end

S.Cxest=Fbank2Cepst(S.Fbxest,-1,P.CepL,0,1,0);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function WriteOutFiles(S,P,do,bn)
%Write Output

PS.y=S.y; 
PS.Fbxest=S.Fbxest;
PS.Cxest=S.Cxest; 
DemoPlotRes(PS,P)



S.Cxest=AppDeltas(S.Cxest,2,2,'feat');
WriteHTKF([do '/' bn '.Cxest'], S.Cxest, 1);
%WriteHTKF([do '/' bn '.FbyNoD'], S.Fbxest, 1);
 

