function [a]=FEEtsi(y, x, do, bn, P)
%ETSI Feature Extractors (FE, xFE, AFE, etc..)


S=EtsiFE(y,x,do,bn,P);
WriteOutFiles(S,do,bn);
a=-1;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=EtsiFE(y,x,do,bn,P)
%Etsi FE Cepstrums
S.y=y(:,end);
fny=NDoub2Int16Wr(S.y,do,bn,'.raw');
fomfc=[do '/' bn '.mfc'];
fopit=[do '/' bn '.pit'];
foclas=[do '/' bn '.clas'];
fovad=[do '/' bn '.vad'];


opt = ['-q -F RAW -fs ' num2str(P.FSamp/1000)];
%bin = [P.SoftRoot '/es_202050v010105p0/AdvancedFrontEnd/Linux/bin/AdvFrontEnd'];
%bin = [P.SoftRoot '/es_201108v010103p0/Extraction_Ccode/FrontEnd'];
%bin =[P.SoftRoot '/es_202211v0103p0/ExtFrontEnd/Linux/bin/ExtFrontEnd'];
bin = [P.SoftRoot '/ES_202_212_software/ExtAdvFrontEnd/Linux/bin/ExtAdvFrontEnd'];


%system([bin ' ' fny ' ' fomfc ' ' opt]);
system([bin ' ' fny ' ' fomfc ' ' fopit ' ' foclas ' ' opt]);
M=ReadHTKF(fomfc,1,0); S.Cxest(2:13,:)=M(1:12,:); S.Cxest(1,:)=M(13,:); 
%system(['rm ' fny ' ' fomfc]);
system(['rm ' fny ' ' fomfc ' ' fopit ' ' foclas ' ' fovad]);


function WriteOutFiles(S,dout,bn)
%Write Output
WriteHTKF([dout '/' bn '.Cxest'], S.Cxest, 1);
imagesc(S.Cxest), axis xy, 
pause








   
		






    
    
    
    
