function [a]=FEAWin(y, x, do, bn, P)
%Feature Extractor Asymetric Window

P.FL=P.FSamp*P.FLSec; 
P.FS=P.FSamp*P.FSSec; 
P.N2pi=2^ceil(log2(P.FL*2)); 
P.win=WinDDRcw([P.FL round(55*P.FSamp/8000) round(200*P.FSamp/8000)]); %win for rx osa
%plot(P.win), pause

S=SegPrepr(P,y,x);
S=YXN(S,P);
WriteOutFiles(S,P,do,bn);
a=min(S.Fbxest(:)); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=SegPrepr(P,ys,xs)
%Segmentations
S.y=ys(:,end);  S.y=OffPreEmph(S.y);
[S.My nf]=Segmx(S.y,P.FL,P.FS);
S.nf=nf;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=YXN(S,P)
%Spectrum 
[xx, xx, S.Rosab, xx]=M2AC(S.My);
S.Xest=Msd(S.Rosab,'rxosa',P.N2pi,P);
S.Fbxest=SmoothFreqCompr(S.Xest,P.NCH,P.FSamp,P.N2pi,P.MF);
S.Cxest=Fbank2Cepst(S.Fbxest,-1,P.CepL,0,1,0);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function WriteOutFiles(S,P,do,bn)
%Write Output

PS.y=S.y; PS.Cxest=S.Cxest; DemoPlotRes(PS,P)

S.Cxest=AppDeltas(S.Cxest,2,2,'feat');
WriteHTKF([do '/' bn '.Cxest'], S.Cxest, 1);
   
    
    
    

    
    
    
    
