function [vadf,GSNR]=VADPitHF(Fby,pit,FricFact,HFSNRTh,ui,FLFr,MinMS)
%VAD based on Pit for voice and High Frequency energy for unvoice

%
[NCH nf]=size(Fby);
FricF=1+floor(FricFact*NCH):NCH;
Y=exp(Fby);
v=pit>1;

%Append 1s
vadv=3*(v);
vad1=VadAdd1s(vadv,ui);
vad1(1:ceil(FLFr/5))=0; vad1(end-ceil(FLFr/5):end)=0; %Obligatory for doing Nest in EstSNRHF

%SNR at each time of High Frequencies
[SNRHF,GSNR]=EstSNRHF(Y,pit,vad1,FricF,FLFr,MinMS);

%ui (20) frames around voiced sequence are 1s
u=(vad1==1)&(SNRHF>HFSNRTh);
vad=vadv; vad(u)=1;

%Stick Unvoice to Voice
vadf=StickU2V(vad); 


% [nr nf]=size(Y);
% subplot(411), imagesc(Fby), axis xy, 
% subplot(412), plot(SNRHF,'r'), hold on, plot(HFSNRTh*ones(1,nf)), hold off, xlim([1 nf]),
% subplot(413), plot(pit),  hold on, plot(vad*mean(pit)/3,'r'), hold off, xlim([1 nf]),
% subplot(414), plot(vadf), xlim([1 nf]),
% pause



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [SNRHF,GSNR]=EstSNRHF(Y,pit,vad1,FricF,FLFr,MinMS)
%
%Nest=FLFrNoise(Y,FLFr);  
VK=false(size(Y)); VK(:,vad1==0)=1; Nest=IntMKnownP(Y,VK,FLFr);

%
Xest=Y-Nest; Xest(Xest<MinMS)=MinMS;
Exest=mean(Xest(FricF,:).^2);
Enest=mean(Nest(FricF,:).^2);
SNRHF=10*log10(Exest./Enest); %SNRHF(vad1~=1)=mean(SNRHF);
GSNR=10*log10(sum(mean(Xest.^2)/mean(Nest.^2)));




function [vad]=VadAdd1s(vadvo,LW)
%Add 1s around voiced frames (3s) of vadvo (vad of voiced and original)
nf=length(vadvo);
vadv=vadvo; vadv(1)=0; vadv(nf-1)=0; %To start and finish with 0
vad=vadv;
for i=2:nf-1    
    if(vadv(i)==3 && vadv(i-1)==0); vad(max(i-LW,1):i-1)=1; end
    if(vadv(i)==0 && vadv(i-1)==3); vad(i:min(i+LW-1,nf))=1; end
end
i=vadvo==3; vad(i)=3;









