function [s,P]=Signals(k,subk,P)
%All outputs are normalized and columned
%Note: edit root paths
%P: Parameters structure (P.N2pi, P.NSamp, P.p, ....);


%Root paths
PhoDir='/clusterFS/home/user/jamc/PostDoc12/ScriptMatlab/Common/Sounds/Phones/';
NA2Dir='/clusterFS/home/user/jamc/SPEECHDATA/A2_All/noises/';

switch k
    case 'PhoJuan'
         s = Int162NDouble([PhoDir subk '.snd']);
    case 'VowTDS'
        fn=[PhoDir subk 'TDS.asc'];
        s = load(fn); 
    case 'PhonRuleSynth'      
        [s,P.M]=PhonRuleSynth(subk,P.FSamp,P.f0,P.N2pi,P.MinMS,P.NSamp);        
    case 'PerPul'       
        f=[0 0.2 0.4 0.6 0.8 1]; M=[1 1 1 1 1 1];
        s=GetPerSignal(P.p,f,M);         
    case 'PerSin'
        %s=RepPerSignal(P.p,P.NSamp);  
        s=SinSignal(P.p,P.NSamp);
    case 'Cons'
        s = Int162NDouble([VowDir subk '.snd']);          
    case 'NA2'       
        s=Int162NDouble([NA2Dir subk '.raw']);         
        
end

l=length(s);
s=reshape(s,[l 1]); 
s=s/max(s);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function x=Int162NDouble(fn)
%Read Int16 file and convert to +-1 Normalized double
[fid] = fopen(fn, 'r', 'b');
x=fread(fid,'int16');
fclose(fid);
x=double(x)/(2^15);

function s=GetPerSignal(pit,f,M)
%GIVE A VECTOR OF ARMA Train Pulse depending on Magnitude Shape
%pit: pitch vector
%f: Corresponding frequencies [0 1 (is Nyquist)]  
%M: Magnitude shape
%p: order should be 2*length(M)+2;
%
pit=[pit(1)*ones(1,1000-1) pit]; l=length(pit); 
imp=zeros(1,l); imp(1)=1; a=pit(1);
for i=1:l
    a=a-1; if a<=0; imp(i)=1; a=pit(i); end
end
%    
p=2*length(M)+2;
b=fir2(p,f,M); a=1; 
s = filter(b,a,imp);
s = s(1000:end);
s=s/max(s);


function x=RepPerSignal(T,N)
%Repeated Period Signal
Np=ceil(N/T(1)); 
xf=randn(1,T);
%xf=zeros(1,T); xf(1)=1;
x=repmat(xf,[1 Np]); x=x(1:N);


function x=SinSignal(T,N)
%Repeated Period Signal
fc=cumsum(1./T);
x=sin(2*pi*fc)+sin(4*pi*fc);



