function [y x n]=Mix(x,n,dB,a)
%MIX (Y=X+N). Starting at a rand point
%a: [0 1] initial point (if not given, a is rand)
%Only noise is rescaled (x is not changed)
if nargin<4 , a=rand; end

lx=length(x);
ln=length(n);

%Cut
if ln>lx
    ip=round(a*(ln-lx));
    n=n(ip+1:ip+lx);
else
    ip=round(a*(lx-ln));
    n=n(ip+1:ip+ln);
end


%Mix
A=10.^(dB/10);
c=var(x)/(var(n)*A);
n=sqrt(c)*n;
y=x+n;
%SNR=10*log10(var(x)/var(n))


