function DDRcw=WinDDRcw(par)
%WINDOW DDRcw with this parameters
%par(1) or L: Length of complete window 
%par(2) or c: Center of win (in k of rx pos, c=0 => max in k=0 or i=1)
%par(3) or w: Wide of  DDR
%Example of a DDR50,250 with L=256: w=WinDDRcw([256 50 250]); plot(w);

        L=par(1);
        c=par(2);
        w=par(3);        
        sh=floor(c-w/2+1); %Shift  
        
        max=w; if (w<L); max=L; end
        waux=zeros(3*max,1);         
        DDR=WinDDR(w);         
        waux((1:w)+max+sh)=DDR((1:w));         
        DDRcw(1:L,1)=waux((1:L)+max);
        
function [DDR]=WinDDR(wide)
%WINDOW DDR WITH A ESPIFIC WIDE (no normalization manteins the Parseval
%Energies)
vent=hamming(ceil(wide/2));
rxaux=xcorr(vent,'biased');
%rxauxn=rxaux./rxaux(ceil(wide/2));
rxauxn=rxaux;
DDR=rxauxn; DDR(wide)=0;

        
   
       
         
