function [Xi]=Mel2Mag(MelX,FSamp,NFT)
%Magnitude To Mel spectrum
%X:     Magnitude spectrogram matrix (without repetion). Rows (freq), Columns (time) 
%       Number of rows should be odd (such as 255, 513, 1025, etc..) 
%MelX:  Corresponding mel spectrogram.


%Parameters
FStart=64;
NCH=size(MelX,1);

%
[Mel, cb]=MelFB(FStart,FSamp,NFT,NCH);

% Normalization
w1=sum(Mel,2); w2=sum(Mel,1);
F=(w1*w2); %w1 is a column and w2 a row
Xi=(Mel./F)'*MelX;

%Delete NaN due to 0 divisions of the last w
i=isnan(Xi); Xi(i)=0;




