function  [Cb,Cu,Cbosa,Cuosa] =M2CC(M1,M2)
%From segmented Matrix to Cross Correlation (by fft) 
%M1: segmented matrix of the signal 1 
%M2: segmented matrix of the signal 2
%Cb:    CC all biased
%Cosab: CC OSA (One Side Autocorrelation) biased 
%Cu:    CC all unbiased
%Cosau: CC OSA (One Side Autocorrelation) unbiased
[FL nf]=size(M1);
%Using fft (very fast)
x1_pad = [M1; zeros(FL,nf)]; x2_pad = [M2; zeros(FL,nf)];
X12_psd = fft(x1_pad).*conj(fft(x2_pad))/FL; 
r_cc = ifft(X12_psd); 
Cb=[r_cc(FL+2:2*FL,:); r_cc(1:FL,:)]; 
Cu=Bi2Un(Cb);
Cbosa=Cb(FL:end,:);
Cuosa=Cu(FL:end,:);
% %To compare fft with xcorr. (Using xcorr is very slow)
% for i=1:nf; x1=M1(:,i); x2=M2(:,i); C(:,i)=xcorr(x1,x2,'unbiased');end; C=C(FL:end,:);
% for i=1:nf; i,plot(Cuosa(:,i)), hold on, stem(C(:,i),'r'), hold off, pause; end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Ru=Bi2Un(Rb)
%From Biased to Unbiased
[FL nf]=size(Rb); FL=(FL+1)/2;
w=FL./(FL:-1:1)'; w=[w(end:-1:2);w];
w=repmat(w,1,nf); Ru=Rb.*w;