function Cyf=Fbank2Cepst(Fby,My,CepL,kl,kc,ke)
%Fbank 2 Cepstrum with Liftering, CMN, sustitute C0 by LogEnergy, 
%To append deltas see AppDeltas function

[FL nf]=size(Fby);


%Cepstrum
MDct=GetMDct(CepL,FL);
Cy=MDct*Fby;

%Liftering
if (kl)
    Cy=Lifter(Cy,22);
end


%LogEnergy
if (ke)    
    Cy(1:CepL-1,:)=Cy(2:CepL,:);
    Cy(CepL,:)=LogEnergy(My);
end

%CMN
if (kc)
    Cym=repmat(mean(Cy,2),1,nf);
    Cy=Cy-Cym;
end

Cyf=Cy;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Cyo=Lifter(Cy,L)
[nr nc]=size(Cy);
v=1+(L/2)*sin(pi*(0:nr-1)/L);
V=repmat(v',[1 nc]); 
Cyo=Cy.*V;

function E=LogEnergy(My)
%
E=log(sum(My.^2));

function MDct=GetMDct(CepL,NCH)
%GET MATRIX FOR DCT
%ETSI matrix for DCT-II 
%Matlab dct is DCT-I
%cos(i,j)=  c(0,1)....c(0,23)
%           c(12,1)...c(12,23)  
NCEP=CepL-1; %Cep Length is different from NCEP (max coef number)
MDct=zeros(NCEP,NCH);
for k=0:NCEP
    for n=0:NCH-1
        MDct(k+1,n+1)=sqrt(2/NCH)*cos((pi*k)*(n+0.5)/NCH);        
    end
end

% MDct=[1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 1.000000000000 
% 0.997668769191 0.979084087682 0.942260922119 0.887885218402 0.816969893010 0.730835964278 0.631087944326 0.519583950035 0.398401089846 0.269796771157 0.136166649096 0.000000000000 -0.136166649096 -0.269796771157 -0.398401089846 -0.519583950035 -0.631087944326 -0.730835964278 -0.816969893010 -0.887885218402 -0.942260922119 -0.979084087682 -0.997668769191 
% 0.990685946036 0.917211301505 0.775711290704 0.576680322115 0.334879612171 0.068242413365 -0.203456013053 -0.460065037731 -0.682553143219 -0.854419404546 -0.962917287348 -1.000000000000 -0.962917287348 -0.854419404546 -0.682553143219 -0.460065037731 -0.203456013053 0.068242413365 0.334879612171 0.576680322115 0.775711290704 0.917211301505 0.990685946036 
% 0.979084087682 0.816969893010 0.519583950035 0.136166649096 -0.269796771157 -0.631087944326 -0.887885218402 -0.997668769191 -0.942260922119 -0.730835964278 -0.398401089846 -0.000000000000 0.398401089846 0.730835964278 0.942260922119 0.997668769191 0.887885218402 0.631087944326 0.269796771157 -0.136166649096 -0.519583950035 -0.816969893010 -0.979084087682 
% 0.962917287348 0.682553143219 0.203456013053 -0.334879612171 -0.775711290704 -0.990685946036 -0.917211301505 -0.576680322115 -0.068242413365 0.460065037731 0.854419404546 1.000000000000 0.854419404546 0.460065037731 -0.068242413365 -0.576680322115 -0.917211301505 -0.990685946036 -0.775711290704 -0.334879612171 0.203456013053 0.682553143219 0.962917287348 
% 0.942260922119 0.519583950035 -0.136166649096 -0.730835964278 -0.997668769191 -0.816969893010 -0.269796771157 0.398401089846 0.887885218402 0.979084087682 0.631087944326 -0.000000000000 -0.631087944326 -0.979084087682 -0.887885218402 -0.398401089846 0.269796771157 0.816969893010 0.997668769191 0.730835964278 0.136166649096 -0.519583950035 -0.942260922119 
% 0.917211301505 0.334879612171 -0.460065037731 -0.962917287348 -0.854419404546 -0.203456013053 0.576680322115 0.990685946036 0.775711290704 0.068242413365 -0.682553143219 -1.000000000000 -0.682553143219 0.068242413365 0.775711290704 0.990685946036 0.576680322115 -0.203456013053 -0.854419404546 -0.962917287348 -0.460065037731 0.334879612171 0.917211301505 
% 0.887885218402 0.136166649096 -0.730835964278 -0.979084087682 -0.398401089846 0.519583950035 0.997668769191 0.631087944326 -0.269796771157 -0.942260922119 -0.816969893010 -0.000000000000 0.816969893010 0.942260922119 0.269796771157 -0.631087944326 -0.997668769191 -0.519583950035 0.398401089846 0.979084087682 0.730835964278 -0.136166649096 -0.887885218402 
% 0.854419404546 -0.068242413365 -0.917211301505 -0.775711290704 0.203456013053 0.962917287348 0.682553143219 -0.334879612171 -0.990685946036 -0.576680322115 0.460065037731 1.000000000000 0.460065037731 -0.576680322115 -0.990685946036 -0.334879612171 0.682553143219 0.962917287348 0.203456013053 -0.775711290704 -0.917211301505 -0.068242413365 0.854419404546 
% 0.816969893010 -0.269796771157 -0.997668769191 -0.398401089846 0.730835964278 0.887885218402 -0.136166649096 -0.979084087682 -0.519583950035 0.631087944326 0.942260922119 0.000000000000 -0.942260922119 -0.631087944326 0.519583950035 0.979084087682 0.136166649096 -0.887885218402 -0.730835964278 0.398401089846 0.997668769191 0.269796771157 -0.816969893010 
% 0.775711290704 -0.460065037731 -0.962917287348 0.068242413365 0.990685946036 0.334879612171 -0.854419404546 -0.682553143219 0.576680322115 0.917211301505 -0.203456013053 -1.000000000000 -0.203456013053 0.917211301505 0.576680322115 -0.682553143219 -0.854419404546 0.334879612171 0.990685946036 0.068242413365 -0.962917287348 -0.460065037731 0.775711290704 
% 0.730835964278 -0.631087944326 -0.816969893010 0.519583950035 0.887885218402 -0.398401089846 -0.942260922119 0.269796771157 0.979084087682 -0.136166649096 -0.997668769191 -0.000000000000 0.997668769191 0.136166649096 -0.979084087682 -0.269796771157 0.942260922119 0.398401089846 -0.887885218402 -0.519583950035 0.816969893010 0.631087944326 -0.730835964278 
% 0.682553143219 -0.775711290704 -0.576680322115 0.854419404546 0.460065037731 -0.917211301505 -0.334879612171 0.962917287348 0.203456013053 -0.990685946036 -0.068242413365 1.000000000000 -0.068242413365 -0.990685946036 0.203456013053 0.962917287348 -0.334879612171 -0.917211301505 0.460065037731 0.854419404546 -0.576680322115 -0.775711290704 0.682553143219];


