function MelY=Cep2Mel(Cy,NCH)
%Cepstrogram To Melgram (in magnitude, not in log) 
%NCH: Number of Channel for the Mel (usually 26)

CepL=size(Cy,1);

MDct=GetMDct(CepL,NCH);
Fby=(MDct'*Cy);

MelY=exp(Fby);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function MDct=GetMDct(CepL,NCH)
%GET MATRIX FOR DCT
%ETSI matrix for DCT-II 
%Matlab dct is DCT-I
%cos(i,j)=  c(0,1)....c(0,23)
%           c(12,1)...c(12,23)  
NCEP=CepL-1; %Cep Length is different from NCEP (max coef number)
MDct=zeros(NCEP,NCH);
for k=0:NCEP
    for n=0:NCH-1
        MDct(k+1,n+1)=sqrt(2/NCH)*cos((pi*k)*(n+0.5)/NCH);        
    end
end