function Ma=AppDeltas(M,dwl,ddwl,KRepr)
%Append Deltas
%dwl: half window lenght of the delta 
%ddwl: half window lenght of the delta-delta 


D=[]; DD=[];

if (dwl>0)
    if(strcmp(KRepr,'mask'))
        D=DeltaBMask(M,dwl);
        
    elseif(strcmp(KRepr,'feat'))
        D=Delta(M,dwl);
    elseif(strcmp(KRepr,'fragm'))
        D=M;
    else
        disp('WARNING: Unknown KRepr fo AppDeltas');
    end     
end

if (ddwl>0)
    DD=Delta(D,ddwl);
end


Ma=[M; D; DD];


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function D=Delta(C,TH)
%TH: half window lenght
[FL nf]=size(C);
D=zeros(FL,nf);
th=1:TH; thm=repmat(th,[FL 1]);
d=2*sum(th.^2);
for t=1+TH:nf-TH  
  n=sum(thm.*(C(:,t+th)-C(:,t-th)),2);
  D(:,t)=n/d;
end
D(:,1:TH)=repmat(D(:,TH),[1 TH]); 
D(:,nf-TH:end)=repmat(D(:,nf-TH),[1 1+TH]); 


function  Db=DeltaBMask(Cs,TH)
%Delta Binary Mask (Cs can be soft but it will be converted into binary)
%TH: half window lenght
%A delta mask pixel is 1 only if all the static are 1 (see 
%http://spandh.dcs.shef.ac.uk/projects/respite/ctk/CTKv1.1.x.reference/DeltaMask.html) 


C=Cs>0.5;
[FL nf]=size(C);
D=zeros(FL,nf);
th=1:TH; 
d=2*TH;
for t=1+TH:nf-TH  
  n=sum([C(:,t+th) C(:,t-th)],2); 
  D(:,t)=n/d;  
end
D(:,1:TH)=repmat(D(:,TH),[1 TH]); 
D(:,nf-TH:end)=repmat(D(:,nf-TH),[1 1+TH]); 
Db=D==1;





