function [y,x,P]=ReNormYX(dy,dx,bn,P)
%Read Normalized (+-1 double) Y (noisy) and X (Clean) signals
%y: in a microphone array, each column correspond to each microphon. 
%The last column is the averaged monosignal or the reference microphone signal.
%

fny=[dy '/' bn P.YExt];
fnx=[dx '/' bn P.XExt];


if (strcmp(P.YExt,'.wav'))
    [y,P.FSamp]=ReSWav(fny); 
    [x,P.FSamp]=ReSWav(fnx);
    if (strcmp(P.SDBase,'EMBEDBAS')); P.Info=ReInfo(dy,bn,length(y(:,1))); end       
elseif (strcmp(P.YExt,'.08')||strcmp(P.YExt,'.wv1'))    
    y=ReInt162NDouble(fny);
    x=ReInt162NDouble(fnx);
    if (strcmp(P.SDBase,'A2')||strcmp(P.SDBase,'A4')); P.FSamp=8000; end    
else
    disp('ERROR: Unknown SpeechDataBase')
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=ReInfo(dy,bn,l)
%
infof=[dy '/' bn '.txt'];
if(exist(infof,'file')==2)
    fi=fopen(infof,'r');
    C = textscan(fi,'%s \t %s \t %s \t  %s \n');
    fclose(fi);
    S.st=C{1}; S.en=C{2}; S.pos=C{3}; bn=C{4};
    l=length(bn); S.bn=cell(l,1);
    for i=1:l;    [pn, S.bn{i}] = fileparts(bn{i}); end
else
    S.st{1}='1'; S.en{1}=num2str(l); S.pos{1}='-1'; S.bn{1}=bn;
end


function [x,fs]=ReSph(fn,wrd)
%Read Sphere format using voiceboox
[x,fs,wrd,phn,ffx]=readsph(fn); 

function [xo,fs]=ReSWav(fn)
%Read Stereo Wave file, fn: file name
[xs,fs,nb]=wavread(fn); 
if (size(xs,2)==2); xo=[xs (xs(:,1)+xs(:,2))/2];
else xo=xs; end







