function [py]=xFEPitch(y,My,do,bn,P,hfl,int,x,Mx)
%EXtended ETSI FE Pitch extractor with my smooting 
%hfl=4; %half filter length for pitch mean
%int=6/5; %pitch interval of search around mean ([1,2])



%
py=xFEPitSm(y,My,do,bn,P,hfl,int);
%px=xFEPitSm(x,Mx,do,bn,P,vf,int);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function p=xFEPitSm(y,My,do,bn,P,vf,int)
%xFE Pitch Smoothed
nf=size(My,2); xp=xFEPitCut(y,do,bn,nf,P);
[xx, xx, Rb, xx]=M2AC(My);
p=SmVADPit(xp,Rb,vf,int,'i');


function p=xFEPitCut(y,do,bn,nf,P)
%xFE Pitch and Cut at nf
if (P.FSSec)~=0.010; disp('WARNING: P.FSSec ~= 0.010 (xFE)'); end 
bin=[P.SoftRoot '/es_202211v0103p0/ExtFrontEnd/Linux/bin/ExtFrontEnd'];
opt = ['-q -F RAW -fs ' num2str(P.FSamp/1000)];
fny=WrNDoub2Int16(y,do,bn,'.raw');
fomfc=[do '/' bn '.mfc'];
fopit=[do '/' bn '.pit'];
foclas=[do '/' bn '.clas'];
fovad=[do '/' bn '.vad'];
system([bin ' ' fny ' ' fomfc ' ' fopit ' ' foclas ' ' opt]);
fi=fopen(fopit,'r'); xp=fread(fi,inf,'float'); fclose(fi);
system(['rm -f ' fny ' ' fomfc ' ' fopit ' ' foclas ' ' fovad]);
p=zeros(1,nf); l=min(nf,length(xp)); p(1:l)=xp(1:l);





