function py=YinPitch(y,P,HTh,SnrTh,VF,x)
%In trastox, compile /private/src/cumnorm_inplace.c, ...with mex (to obtain .mex64)
%follow UseProgram YinPitchOthers script
% VF  = 2;   % (2) voiced filter (for median fielter for binary detection of voiced frames)
% HTh = 0.70;  % (0.8) [0,1] Voiced Harmonicity Thr
% SnrTh = 0;  % (3) SNR Threshold dB



PYin.minf0 = P.MiPitHz;   %Hz - minimum expected F0 (default: 30 Hz)
PYin.maxf0 = P.MaPitHz;  %Hz - maximum expected F0 (default: SR/(4*dsratio))
PYin.sr = P.FSamp; %Hz - sampling rate (usually taken from file header)
PYin.hop = P.FS;   %samples - interval between estimates (default: 32)

   


Ry=yin(y,PYin); [py, vy]=PitVad(Ry.f0,PYin.sr,Ry.ap,Ry.pwr,VF,HTh,SnrTh);
%Rx=yin(x,PYin); [px, vx]=PitVad(Rx.f0,PYin.sr,Rx.ap,Rx.pwr,vth,veth,vf);

% subplot(211), plot(py,'ro'), hold on, plot(px), hold off,
% subplot(212), plot(vy,'ro'), hold on, plot(vx), hold off,
% pause


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [pit, v]=PitVad(f0,sr,ap,pwr,VF,HTh,SnrTh)
%Pitch and Voiced Detector
%ap (better for CHIME) and ap0 of Yin (0-1) fine and gross aperiodicity measure 
%pwr of Yin (0-Inf) period-smoothed instantaneous power 
%HvTh: Voiced Harmonicity Threshold (0.80)
%EvTh: Voiced Energy Threshold (0.05)
%mfl: mode filter length (2)
%v: voiced decision (1 voiced, 0 unvoiced)

i=~isnan(pwr); n=mean(pwr(i))-0.5*sqrt(var(pwr(i)));
Ev=10*log10(pwr/n);

Hv=1-ap;
%vo=(Hv>HTh & Ev>SnrTh)|Hv>HTh; 
vo=(Hv>HTh & Ev>SnrTh); 

v=ModeF(vo*1,VF); 

pit=sr./(440*(2.^f0));
pit(not(v)==1)=0; pit=pit(2:end);

% subplot(311), plot(Hv), hold on, plot(HTh*ones(1,length(v))); hold off
% subplot(312), plot(Ev), hold on, plot(SnrTh*ones(1,length(v))); hold off
% subplot(313), plot(v), hold on, plot(0.9*vo,'r'); hold off, ylim([0 1.2])
% pause


