function py=AcPitch(My,P,HTh,SnrTh,HFL,Int,Mx) 
%Autocorrelation Pitch with smoothing
%HTh=0.60; %0.70 Harmonicity Threshold
%SnrTh=3; %3 dB, SNR Thr
%HFL=4;  %4 half filter length for pitch mean
%Int=6/5; %6/5 pitch interval of search around mean ([1,2])


[py]=AcPit(My,P,HTh,SnrTh,HFL,Int);
%[px]=AcPit(Mx,P,HTh,SnrTh,HFL,Int);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ps]=AcPit(M,P,HTh,SnrTh,HFL,int)
%Parameters, Segmentation, Autocorr
fa=P.MaPitHz ; fb=P.MiPitHz; %Hz
poa=round(P.FSamp/fa)+1; pob=round(P.FSamp/fb)+1;

[xx, xx, Rb, Ru]=M2AC(M);
nf=size(M,2);

%p: pit raw from ac 
[m p]=max(Rb(poa:pob,:)); p=p+poa-2;
pin=sub2ind(size(Ru),p+1,1:nf); 

%Harmonicity and SNR and VAD
H=Ru(pin)./Ru(1,:);
E=Ru(1,:); n=mean(E)-0.5*sqrt(var(E));
SNR=10*log10(E/n);
v=(H>HTh|SNR>SnrTh); 
p(~v)=0;


%Smooth pit
ps=SmVADPit(p,Rb,HFL,int,'n');

% subplot(311), plot(H), hold on, plot(HTh*ones(1,nf)), hold off
% subplot(312), plot(SNR), hold on, plot(SnrTh*ones(1,nf)), hold off
% subplot(313), plot(ps), hold on, plot(p,'ro'), hold off
% pause







