function [oct]=OctEst(Sl,labr,tho,feq,oma,TG)
%Octave Correction


nrl=length(labr); 
oct=zeros(length(nrl),1);
 
for n=1:nrl    
    %Close lines selection
    m=labr(n);
    cl=Sl.xma(:)>Sl.xmi(m) & Sl.xmi(:)<Sl.xma(m); labc=Sl.lab(cl); 
   
    %Octave Estimation
    [oct(n),labo]=OctEstim(m,labc,Sl,tho,feq,oma,TG);      
   
%     subplot(311), M=MLines(m,labc,Sl,TG,'1'); imagesc(M), axis xy
%     subplot(312), M=MLines(m,labo,Sl,TG,'1'); imagesc(M), axis xy
%     subplot(313), imagesc(TG), axis xy
%     pause  
end







%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [oct,labo]=OctEstim(labr,labc,Sl,tho,feq,oma,TG)
%Select Common Lines 
m=labr; xr=Sl.x(m,1:Sl.l(m)); pyr=Sl.py(m,1:Sl.l(m)); Er=Sl.E(m);
nlc=length(labc); cl=zeros(nlc,1); cm=zeros(nlc,1); ci=zeros(nlc,1); f=zeros(nlc,1); 
for n=1:nlc    
    m=labc(n); 
    [cl(n),cm(n),ci(n),f(n)]=CLimitMovimInten(xr,pyr,Sl.x(m,1:Sl.l(m)),Sl.py(m,1:Sl.l(m)),Er,Sl.E(m));   
end
io=POct(cl,cm,ci,tho);  labo=labc(io);
if nlc==1; oct=1;
elseif length(labo)<2; oct=-1;
else oct=Octave(f(io),oma,feq); 
end


function [io]=POct(cl,cm,ci,tho)
%Posible Octaves; th1=0.9; th2=0.7; nl=2;
th1=tho(1); th2=tho(2); nl=tho(3);
io=cl>th1&cm>th1&ci>th1; 
if sum(io)<nl; io=cl>th2&cm>th2&ci>th1;  end
%if sum(io)<nl; io=cl>th1&cm>th2&ci>th1;  end


function [oct]=Octave(x,fma,feq)
%Octave (for lower octave confusions)
eh=zeros(1,fma); eq=zeros(1,fma); oct=-1;
for f=1:fma
    q=1/f; xq=round(x/q)*q; ema=min(q/feq,0.1); eq(f)=sum(abs(x-xq)>ema)+sum(abs(x-xq));
    xqi=min(xq):q:max(xq); eh(f)=length(xqi)-length(intersect(xqi,xq));    
end
et=eq+eh; [mi a]=min(et); oct=find(et<=mi,1,'last'); 
%subplot(313), stem(eq), hold on, plot(eh,'r'), plot(et,'g'), hold off,    
%[sort(x)' oct]








