function [fpym]=MeanPitch(S,shl,TG,pl)
%Mean pitch from auditory chanel energy
i=9/8; %(16/15)

lab=S.lab;
[FL nf]=size(TG); 
[labma]=MaxLinSel(lab,S,shl,'E',TG); %with equal E line chose that which has min pitch
TGl=MLines(-1,labma,S,TG,'E'); TGl(FL,:)=0; 


E=zeros(1,FL);
for n=1:FL        
    mi=max(1,round(n/i)); ma=min(FL,round(n*i));         
    E(n)=sum(sum(TGl(mi:ma,:)));
end
[x p]=max(E); pym=p-1;


%To avoid that pym lower than pl
fpym=pym;
if (fpym<pl+pym/2)
    i=1;
    while(fpym<pl+pym/2)
           fpym=pym*i;
           i=i+1;
    end    
end  

% TGla=MLines(-1,lab,S,TG,'E');  
% subplot(311), imagesc(TG), axis xy
% subplot(312), imagesc(TGla), axis xy
% subplot(313), imagesc(TGl), axis xy
% pause