function [S]=MaxLineTG(Sl,labr,oct,mao,TG)
%Estimate the Tonegram of Maximum lines

Sl=CorrOct(Sl,labr,oct);
[S]=AddOct(Sl,labr,oct,mao,TG); 




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [S]=AddOct(Sl,labr,oct,mao,TG)
%
[FL nf]=size(TG); 
nnok=sum(oct==-1); %number of non OK octave
nok=sum(oct~=-1); nnl=nok*mao+nnok*(2*mao-1);
nl=length(labr); k=0; S=IniS(nnl,nf);
for i=1:nl    
    if oct(i)==-1; mio=mao; E=0; EI=0;
    else mio=1; E=Sl.E(labr(i)); EI=Sl.EI(labr(i),:); end      
    pyo=Sl.py(labr(i),:); x=Sl.x(labr(i),:); l=Sl.l(labr(i)); 
    for o=1:mao; py=pyo*o; k=k+1; S=FillS(k,S,x,py,l,E,EI,FL,nf,TG); end    
    for o=2:mio; py=pyo/o; k=k+1; S=FillS(k,S,x,py,l,E,EI,FL,nf,TG); end    
end



function Slo=CorrOct(Sl,labr,oct)
%
k=oct>0; lab=labr(k); o=oct(k);
Slo=Sl;
for n=1:length(lab)
    j=lab(n);
    py=Sl.py(j,:)/o(n);  
    Slo.py(j,:)=py; 
    Slo.pyma(j)=max(py); 
    Slo.pymi(j)=min(py);   
end





