function TGt=TGTransf(TG,kind,S)
%ToneGram Transformation ([01]Norma, Equalization)


switch kind
    case 'norm'
        ma=max(TG(:)); mi=min(TG(:)); TGt=(TG-mi)/(ma-mi); 
        
    case 'ps2af'
        TGt=PSamp2AFreq(TG,S.pl,S.ph,55,40);
        
end
        
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function TGo=PSamp2AFreq(TGi,pl,ph,p0,n0)
%Pitch Samples to Auditory Frequencies of a ToneGram
%p: pitch in samples (not in pos)
%p0: 55 (pitch of note = 0)
%n0: 30 (notes per oct)
ni=log2(p0/ph)*n0;
nf=log2(p0/pl)*n0;
n=(ni:nf);
p=p0./(2.^(n/n0)); %p=p(end:-1:1);
pc=round(p);
TGo=TGi(pc+1,:);