function CG=TunCGram(y,S)
%Tunelling ChromaGram
[My, nf]=Segmx(y,S.FL,S.FS);
CG=zeros(S.ph,nf);
for p=S.pl:S.ph     
  
   CG(p+1,:)=PITun(My,p,S);   
end

CG=nthroot(CG,3);

%ma=max(CG(:)); mi=min(CG(:)); CG=(CG-mi)/(ma-mi); 
%CG=-1*CG;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Ip=PITun(Mya,p,S)
%Pitch Intensity Tunnelling
NCH=S.NCH; MF=-2.80; SmT=2; Th=0; 
[Y, Nest, NFT]=IPTunNoise(Mya,p); 
%[Y, Nest, NFT]=MTunNoise(Mya,p); 
Fby=SmoothFreqCompr2(Y,NCH,NFT,exp(MF));
Nest=SmoothTime(Nest,SmT); 
Fbnest=SmoothFreqCompr2(Nest,NCH,NFT,exp(MF));

m=SNRMaskYN(exp(Fby),exp(Fbnest),Th,exp(MF));
%mf=Mel2FreM(m,NFT); mf=mf>0.5;
%[NFTh, nf]=size(Y); Xest=zeros(NFTh,nf); Xest(mf)=Y(mf); Ip=(sum(Xest.^2));
[NCH, nf]=size(Fby); Fbxest=zeros(NCH,nf); Fbxest(m)=Fby(m); Ip=sum(exp(Fbxest));
%Ip=sum(exp(Fbnest).^2);
%i=20; plot(Fby(:,i),'r'), hold on, plot(Fbnest(:,i),'k'), hold off, m(:,i)', pause


function [Y, Nest,NFT]=MTunNoise(Mya,p)
%Middle Tun
[FL, nf]=size(Mya); 
NFT=2*FL; wrad=(0:(2*pi/NFT):pi)'; win=hamming(FL); 

St.win=win; St.wrad=wrad;  Y=Msd2(Mya,'x',NFT,St);

%kmax=floor(p*wrad(end)/(2*pi)-1/2);
kmax=ceil(p/2-0.5);
wk=2*pi*((0:kmax)+1/2)/p; 

wk=[0 wk];
St.pit=p; St.wrad=wk; Spk=Msd2(Mya,'x',NFT,St);

Nest=interp1(wk,Spk,wrad); 



function [Y, Nest,NFT]=IPTunNoise(Mya,p)
%Integer Period Tun
[FL, nf]=size(Mya); 
FLp=floor(FL/p)*p; 
NFT=FLp;
My=Mya(1:FLp,:);
win=ones(FLp,1);
%win=hamming(FLp);
Np=FLp/p;
St.win=win; Y=Msd2(My,'x',NFT,St);

[SL, nf]=size(Y); in=true(SL,1); 
in((0:Np:SL-1)+1)=0; in(1)=1; in(SL)=1;
xi=(0:SL-1)';
Nest=interp1(xi(in),Y(in,:),xi,'linear');





function XdB=dB(X)
%
Th=0.02;
i=X<Th; X(i)=Th;
XdB=20*log10(X);
