function TG=NStTGram(y,S,x)
%Non Stationary  
[ipp, ipn]=SFPeak(y);
[D, Np]=SegmPDif(ipp,S.FL,S.FS);
Er=PitDif(D,S.pl,S.ph,S.FL,Np);
TG=sqrt(Er);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Er=PitDif(D,pl,ph,FL,npo)
%Pitch of Difference
[mandi nf]=size(D);
Mi=D~=0; ndo=sum(Mi); 
Erq=zeros(ph,nf);
Ern=zeros(ph,nf);
for p=pl:ph    
    npi=round(FL/p);
    N=round(D/p); Dp=N*p; Erq(p+1,:)=sum(abs(D-Dp))./npo; 
%     hi=npi:-1:0; newz=ndo-sum(N~=0); nma=max(npi,max(N(:)));
%     Hi=repmat([hi; zeros(nma-npi,1)]', [1 nf]);    
%     Ho=hist(N,[0:nma]); Ho(1,:)=npo+newz;   
%     Ern(p+1,:)=sum(abs(Hi-Ho))/npi;    
  Ern(p+1,:)=abs(npo-npi*ones(1,nf))/npi;    
end
m=sqrt(Ern)<0.6; Er=m.*Erq;
subplot(311), imagesc(sqrt(Erq)), axis xy, 
subplot(312), imagesc(sqrt(Ern)), axis xy, 
subplot(313), imagesc(sqrt(Er)), axis xy, 
pause

function [D, Np]=SegmPDif(ip,FL,FS)
%Segmentetion and Pulse Differences
[Mp, nf]=Segmx(ip,FL,FS);
Np=sum(Mp); ma=max(Np); mandi=ma*(ma-1)/2;
D=zeros(mandi,nf);
for i=1:nf
    p=find(Mp(:,i)==1);    
    np=length(p);    
    P=repmat(p,[1 np]); A=P-P'; ind=tril(true(np,np),-1);
    d=A(ind); nd=np*(np-1)/2; 
    D(1:nd,i)=d;     
end


function [ipp, ipn]=SFPeak(x)
%Select and Find Peaks
FL=256; FLh=round(FL/2);
ns=length(x); 
me=zeros(ns,1); sd=zeros(ns,1);
for n=FLh+1:ns-FLh; 
    s=x(n-FLh:n+FLh);
    me(n)=mean(s); 
    sd(n)=sqrt(var(s)); 
end
xe=me+2*sd;
xp=x; i=x<xe; xp(i)=0;
[ipp, imi]=Extrema(xp,0);
xp=x; i=x>-1*xe; xp(i)=0;
[ima, ipn]=Extrema(xp,0);






