function [TG]=HarmTGram(y,S)
%Harmonicity Tonegram

% Parameters and Computing ATGs
pc=S.pl:S.ph; HTh=0.70;
[A,yh]=Cochleagram(y,S,HTh);

%
[nch,mk,nf]=size(A); A0=repmat(A(:,1,:),[1 mk]); An=A./A0;
Anc=An(:,pc+1,:); Ac=A(:,pc+1,:);
H=Anc>HTh; 

%
Ahc=zeros(size(Ac)); Ahc(H)=Ac(H); SAc=sum(Ahc); SHc=sum(H);
SAc=squeeze(SAc); SHc=squeeze(SHc); 

%
TG=zeros(S.ph+1,nf);
TG(pc+1,:)=SAc;

%
TG=nthroot(TG,3);
TG=ImTransf(TG,'norm');

%
%Y=exp(Fb); N=N10FF(Y,10); Y=Y-N;  Fb=nthroot(Y,3);
%m=mean(Fb(:)), s=sqrt(var(Fb(:)))
%a=0.5:0.1:1;
%subplot(311), [C, h]=contour(Fb,a); axis xy


%TG=sqrt(TG); 
%ma=max(TG(:)); mi=min(TG(:)); TG=(TG-mi)/(ma-mi); TG=TG*-1; %TG=histeq(TG,64);
%TG=ResFL(TG);

%
%TG=PSamp2AFreq(TG,S.pl,S.ph,55,30);






%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Jr=ResFL(J)
%Restauratuion Linear Filter
L=11; a=round(L*1/3); b=round(L*2/3)+1; c=b-a+1;
Hd = zeros(L,L); Hd(a:b,a:b)=ones(c,c); 
h=fwind1(Hd,hamming(L));
Jr=filter2(h,J);

function PlotTG(C,A)
%
[nch,mk,nf]=size(A);
for c=1:nch
    c
    A1=squeeze(C(c,:,:)); A3=log(abs(fft(A1)));
    A2=squeeze(A(c,1:120,:)); A2=(A2);    
    e=sum(abs(A2(10:end,:)));    
    subplot(211), imagesc(A1), axis xy
    subplot(212), imagesc(A2), axis xy
    %subplot(313), imagesc(A3), axis xy
    pause
    
end

function PlotA(Ay,i)
[nch,mk,nf]=size(Ay);
%Correlogram
m=0.9;
A=[];
for c=1:nch  
    Ay(c,:,i)
     A(:,c)=(m*c)+Ay(c,:,i);%/max(Ay(c,1,i));
end
subplot(1,2,1), plot(A,'k');

