function Smix=MostSimilarL(lab,S,Sc,TG)
%Most Similar Lines between lab (S) and Sc load in Smix
%Sc: Sc to compare lab of S

[FL nf]=size(TG);
nl=length(lab);
Smix=IniS(nl,nf);

for i=1:nl
    l=lab(i);
    lsc=MSLine(l,S,Sc,TG); 
    if isempty(lsc)
        x=S.x(l,:); py=S.py(l,:); l=S.l(l); E=S.l(l);
    else
        x=Sc.x(lsc,:); py=Sc.py(lsc,:); l=Sc.l(lsc); E=Sc.l(lsc);
    end    
    Smix=FillS(i,Smix,x,py,l,E,FL,nf,TG);    
end

% M=MLines(-1,lab,S,TG,'1'); TGl=TG; TGl(not(M))=0; subplot(211), imagesc(TGl), axis xy
% M=MLines(-1,Smix.lab,Smix,TG,'1'); TGl=TG; TGl(not(M))=0; subplot(212), imagesc(TGl), axis xy, 
% pause



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function lmsc=MSLine(l,S,Sc,TG)
%Most Similar Line (lab of S, and S to compare)

i=Sc.xma(:)>=S.xmi(l) & Sc.xmi(:)<=S.xma(l) & Sc.pyma(:)>=S.pymi(l) & Sc.pymi(:)<=S.pyma(l);
lcc=Sc.lab(i); %reference close lines

nl=length(lcc);
x=S.x(l,1:S.l(l)); py=S.py(l,1:S.l(l)); I=S.E(l);
ct=zeros(1,nl);

for i=1:nl    
    m=lcc(i);
    xc=Sc.x(m,1:Sc.l(m)); pyc=Sc.py(m,1:Sc.l(m)); Ic=Sc.E(m);
    [cl,cm,ci,f]=CLimitMovimInten(x,py,xc,pyc,I,Ic);
    ct(i)=cm+cl;    
end
[v,p]=max(ct); 
lmsc=lcc(p);





