function labf=FLab(labm,S)
%Final Label selection
EL=S.E(labm).*S.l(labm);
%EL=S.E(labm); 
[ELs,is]=sort(EL,'descend'); labm=labm(is); 
ll=length(labm); labf=zeros(1,ll); i=1;
while ll>0
    j=labm(1); labf(i)=j;
    cl=S.xma(labm)>S.xmi(j) & S.xmi(labm)<S.xma(j); labc=labm(cl);    
    labm(cl)=[]; ll=length(labm); i=i+1;  
end
labf=labf(1:i-1);



function [Esi]=PosEMin2(E,L)
%Pos of Energy Min
%E: column Energy; 
%L: min distance betweeen two min
nf=length(E);
[Eima, Eimi]=Extrema(E,0); 
Emi=Eimi.*E;
Emic=zeros(nf,1);
for i=1+L:nf-L
    if (Emi(i)>0); Emic(i)=min(nonzeros(Emi(i-L:i+L)));  end
end
i=Emic==Emi; Emic(not(i))=0;
PEmi=Emic>0; PEmi(1)=1; PEmi(end)=1;   
PosEmi=find(PEmi==1); Esi=interp1(PosEmi,E(PosEmi),1:nf);


function [Sla,labra]=CorrAddOct(Sl,labr,oct,oma,TG)
%Corr and Add Octaves
[FL nf]=size(TG); 
k=oct>0; lab=labr(k); o=oct(k);
for n=1:length(lab)
    j=lab(n);
    Sl.py(j,:)=round(Sl.py(j,:)/o(n)); 
    Sl.pyma(j)=round(Sl.pyma(j)/o(n));Sl.pymi(j)=round(Sl.pymi(j)/o(n));
end

labo=labr(oct==-1); nl=length(labo); 
n=nl*(oma-1); S.lab=zeros(n,1); S.l=zeros(n,1); S.E=zeros(n,1);
S.xmi=zeros(n,1); S.xma=zeros(n,1); S.pymi=zeros(n,1); S.pyma=zeros(n,1);     
S.x=zeros(n,nf);  S.py=zeros(n,nf);  
k=0; last=length(Sl.xmi);
for n=1:nl
    j=labo(n);
    xmi=Sl.xmi(j); xma=Sl.xma(j); l=Sl.l(j);
    x=Sl.x(j,1:l); pyo=Sl.py(j,1:l);      
    for o=2:oma; 
        k=k+1;
        py=round(pyo/o);      
        ind=sub2ind([FL nf],py+1,x); E=mean(TG(ind));
        S.lab(k)=k+last; S.l(k)=l;  S.E(k)=E;
        S.xmi(k)=xmi; S.xma(k)=xma; S.pymi(k)=min(py); S.pyma(k)=max(py); 
        S.x(k,1:l)=x; S.py(k,1:l)=py;        
    end        
end
Sla.lab=[Sl.lab; S.lab]; Sla.l=[Sl.l; S.l]; Sla.E=[Sl.E; S.E];
Sla.xmi=[Sl.xmi; S.xmi]; Sla.xma=[Sl.xma; S.xma]; Sla.pymi=[Sl.pymi; S.pymi]; Sla.pyma=[Sl.pyma; S.pyma]; 
Sla.x=[Sl.x; S.x]; Sla.py=[Sl.py; S.py];
labra=[labr; S.lab]; 


function [ind1,ind2]=MaxLine(BWs,TGlma,TG,xma,yma)
%Max Line from max
[FL nf]=size(TG);
s=sum(BWs); xsmi=find(s>0,1,'first'); xsma=find(s>0,1,'last');   
TGs=TG; TGs(not(BWs))=0; [v,pos]=max(TGs(:,xsmi:xsma)); 
[xi,yi]=ConLine(xsmi:xsma,pos);
ind1=sub2ind([FL nf],yi,xi); ind2=[];



function [xi,yi]=ConLine(x,y)
%Connected Line for a bw image (to avoid unconected big jumps)
%x,y: horizontal and vertical cordenates of an image
mady=max(diff(y)); mady=max(1,mady); 
ns=min(1,1./mady);
xi=min(x):ns:max(x);
yi=interp1(x,y,xi);
xi=round(xi); yi=round(yi);

function [BWml,BWmalc]=MatchOctLin(BWmal,BWl,LinE,TG,TGx)
%Lines which Match with MaxLines and Octave correction of MaxLines 
[FL nf]=size(BWmal);
[Lmal,nrmal]=bwlabel(BWmal);
[Ll,nrl]=bwlabel(BWl);

BWmalc=zeros(FL,nf); BWml=zeros(FL,nf);
for i=1:nrmal
    [r,c]=find(Lmal==i);  ind=sub2ind([FL nf],r,c);
    BWrl=zeros(FL,nf); BWrl(ind)=1;    
    BWcl=BWl;  xmi=max(2,min(c)); xma=min(nf-1,max(c)); 
    BWcl(:,1:xmi-1)=0; BWcl(:,xma+1:end)=0;
    [BWmalca,BWmla,fe]=MO1Lin(BWrl(:,xmi:xma),BWcl(:,xmi:xma)); 
    
    BWmalc(:,xmi:xma)=BWmalc(:,xmi:xma)|BWmalca; BWml(:,xmi:xma)=BWml(:,xmi:xma)|BWmla;   
    
    
end

% subplot(411), imagesc(BWmal), axis xy
% subplot(412), imagesc(BWmalc), axis xy
% subplot(413), imagesc(BWl), axis xy
% subplot(414), imagesc(BWml), axis xy
% pause


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function  [BWrlc,BWml,fe]=MO1Lin(BWrl,BWcl)
%Match lines and Octave Correction of 1 Line; Carefull lr has -1 because pos~=pitch
[FL nf]=size(BWrl);
[Lcl,nrcl]=bwlabel(BWcl);
[v,pr]=max(BWrl); 
BWml=zeros(FL,nf); BWrlc=zeros(FL,nf);
fv=zeros(nrcl,nf);
for i=1:nrcl    
   [r,c]=find(Lcl==i); ind=sub2ind([FL nf],r,c);
   BWc1l=zeros(FL,nf);  BWc1l(ind)=1;
   [v,pc]=max(BWc1l); j=pc>1; 
   lc=pc(j)-1; lr=pr(j)-1;   
   f=lc./lr; fm=mean(f); em=sqrt(var(lr-lc/fm));
   if em<=1; BWml=BWml|BWc1l; le=length(f); fv(i,1:le)=f; end     
end
fe=CFactor(fv,10,nf);
ind=sub2ind([FL nf],round(1+(pr-1)/fe),1:nf); BWrlc(ind)=1;

function fe=CFactor(ndfa,fma,nf)
%Common Factor; (divide by L the sum)
%ndf (n diveded by f)
i=ndfa>0; x=ndfa(i);
sqr=zeros(1,fma); eh=zeros(1,fma);
for f=1:fma
    q=1/f; xq=round(x/q)*q; vqe=var(x-xq); vqt=q^2/24; sqr(f)=sqrt(vqe/vqt); 
    np=min(xq):q:max(xq); h=hist(xq,np); hi=nf*ones(1,length(np)); eh(f)=sum(abs(h-hi))/(fma*nf);
    %eh(f)=sum(abs(h-hi))/(f*nf); %Other posibility
end
et=sqrt(eh.*sqr);
[v fe]=min(et);
%stem(sqr), hold on, plot(eh,'r'), plot(et,'g'), hold off, 
  


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function MainSearchPitch
area=1;
while area>0;    
    [pima,pjma]=MMax(TGlma); %[pmi,pma]=PulLim(PEmi,pjma);   
    
    EL=mean([Es(pmi), Es(pma)]); 
    BWr=BWStrReg(TG,EL,pmi,pma);    
    [PitM,TGlma]=StrLin(PitM,TG,TGlma,BWr,pmi,pma);
    area=sum(TGlma(:))
end




function BWr=BWStrReg(TG,EL,pmi,pma)
%BW Region inside pmi:pma Stripe and bigger than EL
BWr=TG>EL; 
mil=BWr(:,pmi); dmi=[0; (mil(2:end)-mil(1:end-1))==1]; 
mal=BWr(:,pma); dma=[0; (mal(2:end)-mal(1:end-1))==1];
ymi=find(dmi==1); xmi=pmi*ones(length(ymi),1);
yma=find(dma==1); xma=pma*ones(length(yma),1); 
y=[ymi; yma]; x=[xmi; xma];
BWs=zeros(size(TG)); if (~isempty(y)); BWs=bwselect(BWr,x,y); end
BWs(:,pmi:pma)=1; BWr=BWs&BWr;
BWr=bwareaopen(BWr,9);

function [PitMo,TGlo]=StrLin(PitMi,TG,TGl,BWr,pmi,pma)
%pitch Lines of a Stripe
%BWr: Region 1-0 matrix of pitches
%pmi, pma: min and max value where to find max in TGlma
[FL nf]=size(TG);
TGlma=zeros(FL,nf); TGlma(BWr)=TGl(BWr); %TG lines to search max
PitMo=PitMi; %Pit Matrix in
area=sum(TGlma(:));
while (area>0)    
    [yma,xma]=MMax(TGlma);      
    BWs=bwselect(BWr,xma,yma);  
    [ind1,ind2]=MaxLine(BWs,TGlma,TG,xma,yma); PitMo(ind1)=1;  PitMo(ind2)=1;    
    TGlma(BWs)=0; BWr(BWs)=0; area=sum(TGlma(:));       
end
TGlo=TGl; TGlo(BWr)=0; TGlo(:,pmi:pma)=0;