function pit=FinalPitSel(Sdtw,pym,Etg,fmai,vf,shl,TG)
%

labm=LabArPM(Sdtw,pym,fmai); %labs around mean pitch
labf=MaxLinSel(labm,Sdtw,shl,'E',TG); %max lines selection from previus function


[pit]=PitESel(labf,Sdtw,Etg,vf,shl,TG); 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [pit]=PitESel(labf,S,Etg,vf,shl,TG)
%Pitch by using Energy
[FL nf]=size(TG);
TGl=MLines(-1,labf,S,TG,'T'); 
TGli=MLines(-1,labf,S,TG,'I'); 
[x, pprev]=max(TGl); %previus pos
u=pprev==1; %Eu=mean(Etg(u))+vf*sqrt(var(Etg(u)));
ind=sub2ind([FL nf],pprev,1:nf); 
Ev=TGli(ind); 
Ev(u)=min(Ev(~u)); 
Ev=Smooth(Ev,shl);
v=Ev>Etg; 
v=ModeF(1*v,shl);
pit=pprev-1; pit(not(v))=0;

subplot(411), imagesc(TG), axis xy
subplot(412), imagesc(TGli), axis xy
%subplot(412), imagesc(TG), axis xy
subplot(413), plot(Ev), hold on, plot(Etg,'g'), hold off, xlim([1 nf])
subplot(414), plot(pit), xlim([1 nf])
pause

function [pit]=PitESelOld(labf,S,Etg,vf,shl,TG)
%Pitch by using Energy
[FL nf]=size(TG);
TGl=MLines(-1,labf,S,TG,'T'); 
TGli=MLines(-1,labf,S,TG,'I'); 
[x, pprev]=max(TGl); %previus pos
u=pprev==1; Eu=mean(Etg(u))+vf*sqrt(var(Etg(u)));
ind=sub2ind([FL nf],pprev,1:nf); Ev=TGli(ind); Ev(u)=Eu; Ev=Smooth(Ev,shl);
v=Ev>Eu; 
v=ModeF(1*v,shl);
pit=pprev-1; pit(not(v))=0;


