function [Ml]=DTWLinFeat(TG,BWr)
%DTW Lines and their Feat
[Lab,nl]=bwlabel(BWr);
[FL, nf]=size(BWr);
Ml=IniS(nl,nf);
for i=1:nl
    [r,c]=find(Lab==i);      
    ind=sub2ind([FL nf],r,c);       
    TGs=zeros(FL,nf); TGs(ind)=TG(ind); xmi=min(c); xma=max(c); 
    [py,x,l]=RegPit(TGs,xmi,xma,nf);        
    Ml=FillS(i,Ml,x,py,l,0,0,FL,nf,TG);    
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [py,x,l]=RegPit(TGs,xmi,xma,nf)
%Region Line. Return q in its correct position (to xmi)
TG=-1*TGs(:,xmi-1:xma+1)+1;
C = [1 1 1.0; -1 1 1.0; 0 1 1.0; -2 1 1.0; 2 1 1.0; -3 1 1.0; 3 1 1.0]; 
[p,q]=dpfast_cons(TG,C); p=p(2:end-1); q=q(2:end-1)+xmi-2; 
%[x p]=min(TG); p=p(2:end-1); q=xmi:xma;
l=length(q);
x=zeros(1,nf); x(1:l)=q(1:l); 
py=zeros(1,nf); py(1:l)=p(1:l)-1;  
