function IntM=IntMKnownP(M,K,l)
%Interpolate Matrix from Known Points
%l, length of known elements
[nr nc]=size(M);
n=1:nc; 
IntM=zeros(nr,nc);
for r=1:nr
    KR=K(r,:); MR=M(r,:); %known and matrix row
    k=n(KR); uk=n(~KR); %know and unknown elements
    kp=knnsearch(k',uk','k',l); ck=k(kp)'; %closest k   
    IntM(r,uk)=mean(MR(ck));    %interpolation by the mean
end
IntM(K)=M(K);


