function [Fbxest]=Impute(mix,Fby,Fbnest,mask,MF,kind)
%MF: -2.80 for A2 min of LogMelFilterbank

switch kind
    case 'BinI' 
        Fbxest = binaryImputation(Fby, mask, mix, 'bcmi', 'bcp');
    case 'SofI'
        Fbxest = softImpute(Fby, mask, mix, MF);
    case 'Vts'    
        Fbxest = bvts(Fby, Fbnest, zeros(size(Fbnest)), mix, 'simple', 0);
	case 'VtsCov' %mask is the cov!		
	    Fbxest = bvts(Fby, Fbnest, mask, mix, 'simple', 1);					
    case 'Mask'
        Fbxest=Fby; Fbxest(mask==0)=MF;
    otherwise
        fprintf('ERROR: Unknown imputation method\n')
end


