function est= kimTempImputation( data, mask, gmm, imputationAlgorithm, probComputation )

switch imputationAlgorithm
    case 'bmap'
        impute= @bmapImputation;
    case 'map'
        impute= @mapImputation;
    case 'faubel'
        impute= @boundedConditionalMeanImputation;
    case 'bcmi'
        impute= @boundedConditionalMeanImputation2;
    case 'eig'
        impute= @boundedConditionalMeanImputationEig;
    case 'svd'
        impute= @boundedConditionalMeanImputationSvd;
end

switch probComputation
    case 'diag'
        probability= @boundedProbabilityDiag;
    case 'faubel'
        probability= @boundedProbabilityFaubel;
    case 'bcp'
        probability= @boundedProbability2;
    case 'eig'
        probability= @boundedProbabilityEig;
    case 'svd'
        probability= @boundedProbabilitySvd;        
end

tlag= gmm.tlag;
[params frames]= size(data);
est= data(:, tlag+1:end-tlag);
mask2= mask(:, tlag+1:end-tlag);

for i=1:params
    for t= find( ~mask2(i,:) )
        %Define the temporal spectral feature vectors
        y= data(i, t:t+2*tlag)';
        m= mask(i, t:t+2*tlag)';
        v_aux= cumsum( ~m );
        index= v_aux(tlag+1); %Indicates the number of unreliable components from y(1) until y(tlag+1)
        
        %Compute the posteriors for every Gaussian
        p= zeros(gmm.models{i}.ncentres, 1);
        for k=1:gmm.models{i}.ncentres
            p(k)= probability( y, m, gmm.models{i}, k );
        end
        p= p/sum(p);
        
        %Compute the partial estimates for y(i,t)
        xest= zeros(gmm.models{i}.ncentres, 1);
        for k=1:gmm.models{i}.ncentres
            aux= impute( y, m, gmm.models{i}, k );
            xest(k)= aux(index);
        end

        %Combine the partial estimates according to their posterior
        %probabilities
        est(i,t)= sum( p.*xest );
    end
end
est= min( est, data(:,tlag+1:end-tlag) ); 
