function finalImp= combineFreqTempEstimates( freqImp, tempImp, mask, alfa, thrFreq, thrTemp )

if nargin < 6
    thrTemp= 0.75;
end

if nargin < 5
    thrFreq= 0.75;
end

if nargin < 4
    alfa= 0.7;
end

%Combine both estimates according to their reliability measures
[params frames1]= size( freqImp );
frames2= size( tempImp, 2 );
tlag= (frames1-frames2)/2;

mask2= mask(:,tlag+1:end-tlag);
freqImp= freqImp(:, tlag+1:end-tlag);

finalImp= freqImp;
relFreq= sum( mask2 ); %Reliability of the frequency-based imputation

% for t= find( relFreq < thrFreq*params )
%     for i= find( ~mask2(:,t)' )
%         relTemp= sum( mask(i,t:t+2*tlag) ); %Reliability of the temporal-based imputation
%         if relTemp==0 && relFreq(t)>0
%             finalImp(i,t)= freqImp(i,t);
%         elseif relTemp>=thrTemp*(2*tlag+1) || (relFreq(t)==0 && relTemp>0)
%             finalImp(i,t)= tempImp(i,t);
%         else
%             finalImp(i,t)= alfa*freqImp(i,t) + (1-alfa)*tempImp(i,t);
%         end
%     end
% end

for t= find( relFreq < thrFreq*params )
    for i= find( ~mask2(:,t)' )
        relTemp= sum( mask(i,t:t+2*tlag) ); %Reliability of the temporal-based imputation
        if relTemp>=thrTemp*(2*tlag+1)
            finalImp(i,t)= tempImp(i,t);
        else
            finalImp(i,t)= alfa*freqImp(i,t) + (1-alfa)*tempImp(i,t);
        end
    end
end