function P= boundedProbabilityFaubel ( y, m, gmm, k, logProbs )

LOWER_BOUND= -Inf;

if nargin == 4
    logProbs= false;
end

%Bounded probability assuming diagonal covariance matrices
if strcmp(gmm.covar_type,'diag')
    P= boundedProbabilityDiag( y, m, gmm, k, logProbs );
else
    u= gmm.centres(k,:)';
    S= gmm.covars(:,:,k);
    
    xr= y(m);
    xu= y(~m);
    ur= u(m);
    uu= u(~m);
    [Sr, Sur, Su]= splitCovariance( S, m );

    %Probability of the reliable components
    if ~isempty(xr)
        pr= mvnpdf(xr, ur, Sr);
        
        zr= Sr \ (xr-ur);
        u_u_r= uu + Sur*zr; %Mean of the conditional Gaussian distribution of u given r
        S_u_r= Su - Sur*(Sr\Sur'); %Covariance of the conditional Gaussian distribution of u given r
    else
        pr= 1;
        u_u_r= uu;
        S_u_r= Su;
    end

    A= chol( inv(S_u_r) );
    zu= A*(xu-u_u_r);
    pu= normcdf( zu ); %We assume that the lower bound is -Inf
    
    ck= gmm.priors(k); %Prior of the Gaussian k
    if logProbs
        P= sum( log([ck; pr; pu]) );
    else
        P= prod( [ck; pr; pu] );
    end
end
