function P= boundedProbability2Fast ( y, m, gmm_xr, gmm_xu, k )

%Bounded probability assuming diagonal covariance matrices
if (~isempty(gmm_xr) && strcmp(gmm_xr.covar_type,'diag')) || (~isempty(gmm_xu) && strcmp(gmm_xu.covar_type,'diag'))
    P= boundedProbabilityDiagFast( y, m, gmm_xr, gmm_xu, k );
else
    xr= y(m);
    xu= y(~m);
    
    %Posterior of the reliable components
    pr= 1;
    if ~isempty(xr)
        ur= gmm_xr.centres(k,:)';
        if iscell( gmm_xr.covars )
            Sr= gmm_xr.covars{k};
        else
            Sr= gmm_xr.covars(:,:,k);
        end
        pr= mvnpdf(xr, ur, Sr);
    end
    
    %Prob of the unreliable components
    pu= 1;
    if ~isempty(xu)
        uu= gmm_xu.centres(k,:)';
        if iscell( gmm_xu.covars )
            Su= gmm_xu.covars{k};
        else
            Su= gmm_xu.covars(:,:,k);
        end
        su= sqrt(abs(full(diag(Su))));
        zu= (xu-uu)./su;
        pu= normcdf( zu );
    end
    
    P= prod( [pr; pu] );
end
