function varargout= boundedConditionalMeanImputationDiag( y, m, gmm, k )
xu= y(~m);
mu_u= gmm.centres(k,~m)';
if strcmp(gmm.covar_type,'diag')
    s= gmm.covars(k,:)';
else
    if iscell( gmm.covars )
        s= full( diag(gmm.covars{k}) );
    else
        s= diag(gmm.covars(:,:,k));
    end
end
var_u= s(~m);
std_u= sqrt(var_u); %Standard deviations of the unreliable components
zu= (xu-mu_u)./std_u;
q= -normpdf(zu)./normcdf(zu);
q(isnan(q) | isinf(q))= 0;
correction= std_u.*q; %We assume that the imputation lower bound is -Inf
xu_est= mu_u + correction;

varargout{1}= min([xu_est y(~m)], [], 2); %Bounded imputation: 0<= xu(i) <= y(i)
if nargout > 1
    varargout{2}= diag( var_u.*(1 + q.*(zu-q)) );
end
