function xu_est= bmapImputation( y, m, gmm, k )

MAX_ITER= 5;
MIN_ERR= 1e-4;

xr= y(m);
mu_r= gmm.centres(k,m)';
mu_u= gmm.centres(k,~m)';

%The MAP estimate is the unconditional mean of the unreliable components
if strcmp(gmm.covar_type,'diag') || isempty(xr)
    xu_est= min( [mu_u y(~m)], [], 2 );
%BMAP estimation proposed by Raj2004
else
    S= gmm.covars(:,:,k);
     
    %1. Initialization of the estimate
    xest= y; %Default initialization proposed by Raj
    [Sr, Sur, Su]= splitCovariance(S, m); %A different initialization
    z= Sr \ (xr-mu_r); %z= inv(Sr) * (xr-mu_r)
    xu_est2= mu_u + Sur*z;
    xest(~m)= xu_est2;
    xest= min( [xest y], [], 2 );
    xest_prev= xest;
   
    %2. Main loop
    i= 0;
    err= Inf;
    while i<MAX_ITER && err>MIN_ERR
        for j= find(~m)' %For each of the j unreliable components
            %2a. Compute the MAP estimate for unreliable component j
            %assuming that all the others components are reliable
            m2= true(size(m));
            m2(j)= false;
            mu_r2= gmm.centres(k,m2)';
            mu_u2= gmm.centres(k,~m2)'; 
            [Sr2, Sur2, Su]= splitCovariance(S, m2);
            z= Sr2\(xest(m2)-mu_r2); %z= inv(Sr2) * (xest(m2)-mu_r2)
            xu_est2= mu_u2 + Sur2*z;
            
            %2b. Computation of the bounded estimate
            xest(~m2)= xu_est2;
            xest= min( [xest y], [], 2 );            
        end
        
        err= sum(abs(xest-xest_prev));
%         disp( ['It. ' num2str(i) ' error: ' num2str(err)]);
        
        xest_prev= xest;
        i= i+1;
    end
    
    xu_est= xest(~m);
end
