function VTSImputation ( fileList, gmm, imputationAlgorithm, vtsOrder, noMaskInfo, byteOrder )

%------------------------------------------------------------------------
% CHECK THE PROGRAM ARGUMENTS 
%------------------------------------------------------------------------

if nargin < 6
    byteOrder= 'l'; %Big-endian
end

if nargin < 5
    noMaskInfo= 0;
else
    noMaskInfo= str2double( noMaskInfo );
end

if nargin < 4
    order= 1;
else
    order= str2double( vtsOrder );
end

if nargin < 3
    imputationAlgorithm= 'simple'; %'simple', 'mapr', 'bcmir', 'mapx', 'bcmix'
end


%------------------------------------------------------------------------
% PROGRAM STARTS 
%------------------------------------------------------------------------

%Read the list of files
if noMaskInfo
    [listIn, listNest, listNvar, listEst]= textread( fileList, '%s %s %s %s' );
else
    [listIn, listMask, listNest, listNvar, listEst]= textread( fileList, '%s %s %s %s %s' );
end
nfiles= length(listIn);

%Read the mix variable of the gmm file
load(gmm, 'mix');

% mse1= 0;
% mse2= 0;
% tic
for f=1:nfiles
    disp( ['Processing file ' num2str(f) '/' num2str(nfiles) ' ...'] );
    
    %Read the input speech file
    [data, frmPeriod, sampKind]= readhtk(listIn{f}, byteOrder);
    
    %Read the noise estimates and their corresponding variances
    nest= readhtk(listNest{f}, byteOrder);
    nvar= readhtk(listNvar{f}, byteOrder);    

    %Read the missing-data mask (HTK format)
    if noMaskInfo
        mask= false(size(data));
    else
        mask= readhtk( listMask{f}, byteOrder );
        mask= (mask== 1);
    end
        
    %Impute the noise corrupted features
    imputedData= vtsBinaryImputation( data, mask, nest, nvar, mix, imputationAlgorithm, order );

%     [path, name, ext]= fileparts( listIn{f} );
%     cleanFile= ['Aurora2/fbank/clean1/' name ext];
%     cf= readhtk( cleanFile, byteOrder );
%     mse1= mse1 + sum(sum((cf-data).^2));
%     mse2= mse2 + sum(sum((cf-imputedData).^2));

    %Save the imputed ratemap
    writehtk(listEst{f}, imputedData, frmPeriod, sampKind, byteOrder);
end
% toc
% 
% disp( ['MSE noisy: ' num2str(mse1) ] );
% disp( ['MSE imputed: ' num2str(mse2) ] );
