function ImputeMissingData ( fileList, gmm, maskType, imputationAlgorithm, probComputation, byteOrder, computeVars )

%------------------------------------------------------------------------
% CHECK THE PROGRAM ARGUMENTS 
%------------------------------------------------------------------------

if nargin < 7
    computeVars= 0;
else
    computeVars= str2num( computeVars );
end

if nargin < 6
    byteOrder= 'l'; %Big-endian
end

if nargin < 5
    probComputation= 'diag';
end

if nargin < 4
    imputationAlgorithm= 'map'; %Alteratively, imputationAlgorithm='map', imputationAlgorithm='faubel'
end

if nargin < 3
    maskType= 'binary'; %{'soft','binary'};
end

switch maskType
    case 'binary'
        impute= @binaryImputation;
    case 'fb'
        impute= @forwardBackwardImputation;
    case 'soft'
        impute= @softImputation;
    otherwise
        disp(['Error: unknown mask type ' maskType]);
        return;
end


%------------------------------------------------------------------------
% PROGRAM STARTS 
%------------------------------------------------------------------------

%Read the list of files with: inputFile inputMask outputFile
if computeVars
    [listIn, listMask, listEst listVars]= textread( fileList, '%s %s %s %s' );
else
    [listIn, listMask, listEst]= textread( fileList, '%s %s %s' );
end
nfiles= length(listIn);

%Read the mix variable of the gmm file
load(gmm, 'mix');

% mse1= 0;
% mse2= 0;
% tic
for f=1:nfiles
    disp( ['Processing file ' num2str(f) '/' num2str(nfiles) ' ...'] );
    
    %Read the input speech file
    [data, frmPeriod, sampKind]= readhtk(listIn{f}, byteOrder);

    %Read the missing-data mask (HTK format)
    mask= readhtk( listMask{f}, byteOrder );
    if strcmp(maskType, 'binary') || strcmp(maskType, 'fb')
        mask= mask==1;
    end

    %Impute the noise corrupted features
    if computeVars
        [imputedData varImputation]= impute( data, mask, mix, imputationAlgorithm, probComputation );
    else
        imputedData= impute( data, mask, mix, imputationAlgorithm, probComputation );
    end

%     [path, name, ext]= fileparts( listIn{f} );
%     cleanFile= ['Aurora2/fbank/clean1/' name ext];
%     cf= readhtk( cleanFile, byteOrder );
%     mse1= mse1 + sum(sum((cf-data).^2));
%     mse2= mse2 + sum(sum((cf-imputedData).^2));

    %Save the imputed ratemap
    writehtk(listEst{f}, imputedData, frmPeriod, sampKind, byteOrder);
    if computeVars
        writehtk(listVars{f}, varImputation, frmPeriod, 9, byteOrder); %USER_KIND=9
    end
end
% toc
% % 
% disp( ['MSE noisy: ' num2str(mse1) ] );
% disp( ['MSE imputed: ' num2str(mse2) ] );
