//Input Output FILE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
 
 
typedef struct HtkHead{
                          unsigned int nSamples;
                          unsigned int sampPeriod;
                          unsigned short int sampSize;
                          unsigned short int sampKind;
                          }HtkHead;


//////////////////////////////////////////////// SubFun /////////////////////////////////////////////
			  
//Read Htk Header
void ReHtkHeader (FILE *fp, int *nf, char *kind, int *lv)
{
    HtkHead header;
    
    fseek (fp, 0L, SEEK_SET);
    fread (&header.nSamples, sizeof (long), 1, fp);
    fread (&header.sampPeriod, sizeof (long), 1, fp);
    fread (&header.sampSize, sizeof (short), 1, fp);
    fread (&header.sampKind, sizeof (short), 1, fp);
	
    *nf= header.nSamples;
    *lv = header.sampSize/4;    
    *kind=header.sampKind;
	

	
}



//////////////////////////////////////////////// Fun /////////////////////////////////////////////


//Read Htk File
//Call: int nr, nc; float *M; M=ReHtkF(&nr,&nc,argv[1]);
float* ReHtkF(int *nr, int *nc, char *fn)
{
	FILE *fp=NULL; 
	char khead;
	int i, j;
	float a, *M;
	
	fp=fopen(fn, "rb");	
	ReHtkHeader(fp, nc, &khead, nr); //nr and nc		
	M = (float*) malloc((*nr)*(*nc) * sizeof(float));	
	for(j=0; j<*nc; j++)
	  fread(&M[0+j*(*nr)], sizeof(float), *nr, fp); //M[i+j*nr]=M[i][j]	  
	fclose(fp);	
	return M;	
}

