function [allacg] = correlogramModelFGT(x,lowcf,highcf,numchans,fs,winsize,frameshift, FL, FS)
%A MODIFICATION OF NING PROGRAM
% Parameters are:
% 
% x - signal to process
% lowcf - lowest centre frequency in Hz
% highcf - highest centre frequency in Hz
% numchans - number of frequency channels
% fs - sample rate in Hz
% winsize - window size for autocorrelation in msec (usually use 20 msec or longer)
% frameshift - hop size (usually half the window size)
%
% Modified from Guy's code

% list of channel centre frequencies

cf=MakeErbCFs(lowcf,highcf,numchans);

% framing - pad the end with zeros to get an exact number of frames

frameshift_samples=round(frameshift*fs/1000);
winsize_samples=round(winsize*fs/1000);
maxdelay=floor(winsize_samples/2);
%numframes=ceil(length(x)/frameshift_samples);  %Ning nf
numframes=ceil((length(x)-FL)/FS);              %Juan nf


x=[x ; zeros(numframes*frameshift_samples-length(x),1)]; x=x(:)';

win = hanning(winsize_samples)';

allacg = zeros(numchans, maxdelay, numframes);
bmbuffer = zeros(numchans, winsize_samples-frameshift_samples+length(x));

%Half-wave channel ouputs
for c=1:numchans
    %bmbuffer(c,winsize_samples-frameshift_samples+1:end) = gammatone_c(x,fs,cf(c),1);
    bmbuffer(c,1:end-winsize_samples+frameshift_samples) = gammatone_c(x,fs,cf(c),1);
end

% Compute auto-correlation
for frame=1:numframes
    range = (frame-1)*frameshift_samples+1:(frame-1)*frameshift_samples+winsize_samples;
    allacg(:,:,frame) = correlogram_norm(bmbuffer(:,range),win);
end

%To avoid 0s in rx(0)
a0=allacg(:,1,:); i=a0==0; m=min(a0(not(i))); a0(i)=m;  allacg(:,1,:)=a0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function y=MakeErbCFs(lfhz,hfhz,n)
% make ERB cfs
y=ErbRateToHz(linspace(HzToErbRate(lfhz),HzToErbRate(hfhz),n));

function y=ErbRateToHz(x)
% erb to hz conversion
y=(10.^(x/21.4)-1)/4.37e-3;

function y=HzToErbRate(x)
% hz to erb conversion
y=(21.4*log10(4.37e-3*x+1));

function a=correlogram_norm(m,window)
% Normalise the ACG
[r,c]=size(m); %r: n channels, c: frame length
m=m.*repmat(window,r,1);

a = real(ifft(abs(fft(m,[],2)).^2,[],2));
a = a(:,1:floor(c/2));
a(a<0) = 0; %Be careful, sometimes is neg or even 0.

% Normalise the ACG
a = a ./ repmat(c-(0:c/2-1),r,1);
a = sqrt(a);











