function [Fby,Ay]=ShefCochlCorrGram(y, FSamp, LCFHz, HCFHz, NCH, FLms, FSms, TIms, COMPR, MF, FL, FS)
%Sheffield Cochleo and Correlo -Grama
%IMPORTANT NOTES: 
%1) Multiply by log(10) to work with exp() to obtain magnitude
%2) Ning Ma obtains nf from: nf=ceil(length(y)/S.FS) but Juan from 
%   nf=ceil((length(y)-FL)/FS) which is the correct.
%3) We take the mean of the smoothed envelope as the energy value in each
%frame rather than simply sampling it. It's the same for correlogramModelFGT

Fbyo = makeRateMap_c(y, FSamp, LCFHz, HCFHz, NCH, FSms, TIms, COMPR)*log(10);
Ayo = correlogramModelFGT(y, LCFHz, HCFHz, NCH, FSamp, FLms, FSms, FL, FS);

%Cut and Limit
nf=ceil((length(y)-FL)/FS); 
Fby=Fbyo(:,1:nf);
Ay=Ayo(:,:,1:nf);



i=Fby<MF; Fby(i)=MF;
