function Ch=HzToErbCh(f,nch,lf,hf)
%f in Hz To corresponding Erb Channel
%Ch: 1...nch (not start in 0)
SpaErb=(HzToErbRate(hf)-HzToErbRate(lf))/(nch-1);
Ch=1+(HzToErbRate(f)-HzToErbRate(lf))/SpaErb;

function erb= HzToErbRate(f)  
erb=(21.4*log10(4.37e-3*(f)+1.0));

function f=ErbRateToHz(erb)  
erb=((pow(10.0,((erb)/21.4))-1.0)/4.37e-3);